/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.openinv.lib.planarwrappers.util.version;

import com.github.jikoo.openinv.lib.planarwrappers.util.version.StringVersion;
import com.github.jikoo.openinv.lib.planarwrappers.util.version.Version;
import org.jetbrains.annotations.NotNull;

class IntVersion
implements Version {
    private final int[] data;
    private String toString;

    IntVersion(int ... data) {
        this.data = data;
    }

    public boolean equals(Object obj) {
        Version that;
        return this == obj || obj instanceof Version && this.compareTo(that = (Version)obj) == 0;
    }

    public int hashCode() {
        int hash = 1;
        for (int index = this.data.length - 1; index >= 0; --index) {
            if (hash == 1 && this.data[index] == 0) continue;
            hash = hash * 67 + this.data[index];
        }
        return hash;
    }

    public String toString() {
        if (this.toString != null) {
            return this.toString;
        }
        int maxLength = this.data.length - 1;
        StringBuilder builder = new StringBuilder();
        for (int index = 0; index <= maxLength; ++index) {
            builder.append(this.data[index]);
            if (index == maxLength) continue;
            builder.append('.');
        }
        this.toString = builder.toString();
        return this.toString;
    }

    @Override
    public int compareTo(@NotNull Version other) {
        if (!(other instanceof IntVersion)) {
            return StringVersion.COMPARATOR.compare(this.toString(), other.toString());
        }
        IntVersion that = (IntVersion)other;
        int compareLen = Math.max(this.data.length, that.data.length);
        for (int index = 0; index < compareLen; ++index) {
            int thatData;
            int thisData = this.data.length > index ? this.data[index] : 0;
            int compare = thisData - (thatData = that.data.length > index ? that.data[index] : 0);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

