/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.openinv.lib.planarwrappers.util;

import java.util.Comparator;

public class AlphanumComparator
implements Comparator<String> {
    protected final boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private StringBuilder getChunk(CompareData data) {
        StringBuilder chunk = new StringBuilder();
        char c2 = data.string.charAt(data.marker);
        chunk.append(c2);
        ++data.marker;
        boolean expectingDigit = this.isDigit(c2);
        while (data.marker < data.length && expectingDigit == this.isDigit(c2 = data.string.charAt(data.marker))) {
            chunk.append(c2);
            ++data.marker;
        }
        return chunk;
    }

    protected int compareNumeric(StringBuilder thisChunk, StringBuilder thatChunk) {
        int result = thisChunk.length() - thatChunk.length();
        int thisIndex = 0;
        int thatIndex = 0;
        if (result != 0) {
            thisIndex = this.getUnpaddedStart(thisChunk);
            thatIndex = this.getUnpaddedStart(thatChunk);
            if ((result += thatIndex - thisIndex) != 0) {
                return result;
            }
        }
        while (thisIndex < thisChunk.length()) {
            result = thisChunk.charAt(thisIndex) - thatChunk.charAt(thatIndex);
            if (result != 0) {
                return result;
            }
            ++thisIndex;
            ++thatIndex;
        }
        return result;
    }

    private int getUnpaddedStart(CharSequence chunk) {
        for (int index = 0; index < chunk.length(); ++index) {
            if (chunk.charAt(index) == '0') continue;
            return index;
        }
        return chunk.length() - 1;
    }

    protected int compareAlphabetic(StringBuilder thisChunk, StringBuilder thatChunk) {
        return thisChunk.compareTo(thatChunk);
    }

    protected int compareTail(CompareData data1, CompareData data2) {
        return data1.length - data2.length;
    }

    @Override
    public int compare(String s1, String s2) {
        CompareData data1 = new CompareData(s1);
        CompareData data2 = new CompareData(s2);
        while (data1.marker < data1.length && data2.marker < data2.length) {
            StringBuilder thisChunk = this.getChunk(data1);
            StringBuilder thatChunk = this.getChunk(data2);
            int result = this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0)) ? this.compareNumeric(thisChunk, thatChunk) : this.compareAlphabetic(thisChunk, thatChunk);
            if (result == 0) continue;
            return result;
        }
        return this.compareTail(data1, data2);
    }

    protected static final class CompareData {
        private int marker = 0;
        private final String string;
        private final int length;

        private CompareData(String string) {
            this.string = string;
            this.length = string.length();
        }

        public int getMarker() {
            return this.marker;
        }

        public String getString() {
            return this.string;
        }

        public int getLength() {
            return this.length;
        }
    }
}

