/*
 * Decompiled with CFR 0.152.
 */
package com.github.jikoo.openinv.lib.nahu.scheduler-wrapper.implementation.bukkit;

import com.github.jikoo.openinv.lib.nahu.scheduler-wrapper.WrappedScheduler;
import com.github.jikoo.openinv.lib.nahu.scheduler-wrapper.implementation.bukkit.task.BukkitWrappedTask;
import com.github.jikoo.openinv.lib.nahu.scheduler-wrapper.task.WrappedTask;
import com.github.jikoo.openinv.lib.nahu.scheduler-wrapper.type.ImplementationType;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class BukkitWrappedScheduler
implements WrappedScheduler {
    private static final ImplementationType IMPLEMENTATION_TYPE = ImplementationType.BUKKIT;
    private final Plugin plugin;
    private final BukkitScheduler scheduler;

    public BukkitWrappedScheduler(@NotNull Plugin plugin) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin cannot be null!");
        this.scheduler = Bukkit.getScheduler();
    }

    @Override
    @NotNull
    public ImplementationType getImplementationType() {
        return IMPLEMENTATION_TYPE;
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void cancelAllTasks() {
        this.scheduler.cancelTasks(this.plugin);
    }

    @Override
    public void cancelTask(@NotNull WrappedTask wrappedTask) {
        wrappedTask.cancel();
    }

    @Override
    @NotNull
    public WrappedTask runTask(@NotNull Runnable runnable) {
        return this.setupTask(this.scheduler.runTask(this.plugin, runnable));
    }

    @Override
    @NotNull
    public WrappedTask runTaskAsynchronously(@NotNull Runnable runnable) {
        return this.setupTask(this.scheduler.runTaskAsynchronously(this.plugin, runnable));
    }

    @Override
    @NotNull
    public WrappedTask runTaskAtEntity(@NotNull Entity entity, @NotNull Runnable runnable) {
        return this.runTask(runnable);
    }

    @Override
    @NotNull
    public WrappedTask runTaskAtLocation(@NotNull Location location, @NotNull Runnable runnable) {
        return this.runTask(runnable);
    }

    @Override
    @NotNull
    public WrappedTask runTaskTimer(@NotNull Runnable runnable, long delay, long period) {
        return this.setupTask(this.scheduler.runTaskTimer(this.plugin, runnable, delay, period));
    }

    @Override
    @NotNull
    public WrappedTask runTaskTimerAsynchronously(@NotNull Runnable runnable, long delay, long period) {
        return this.setupTask(this.scheduler.runTaskTimerAsynchronously(this.plugin, runnable, delay, period));
    }

    @Override
    @NotNull
    public WrappedTask runTaskTimerAtEntity(@NotNull Entity entity, @NotNull Runnable runnable, long delay, long period) {
        return this.runTaskTimer(runnable, delay, period);
    }

    @Override
    @NotNull
    public WrappedTask runTaskTimerAtLocation(@NotNull Location location, @NotNull Runnable runnable, long delay, long period) {
        return this.runTaskTimer(runnable, delay, period);
    }

    @Override
    @NotNull
    public WrappedTask runTaskLater(@NotNull Runnable runnable, long delay) {
        return this.setupTask(this.scheduler.runTaskLater(this.plugin, runnable, delay));
    }

    @Override
    @NotNull
    public WrappedTask runTaskLaterAsynchronously(@NotNull Runnable runnable, long delay) {
        return this.setupTask(this.scheduler.runTaskLaterAsynchronously(this.plugin, runnable, delay));
    }

    @Override
    @NotNull
    public WrappedTask runTaskLaterAtEntity(@NotNull Entity entity, @NotNull Runnable runnable, long delay) {
        return this.runTaskLater(runnable, delay);
    }

    @Override
    @NotNull
    public WrappedTask runTaskLaterAtLocation(@NotNull Location location, @NotNull Runnable runnable, long delay) {
        return this.runTaskLater(runnable, delay);
    }

    @NotNull
    private WrappedTask setupTask(@NotNull BukkitTask task) {
        return new BukkitWrappedTask(task);
    }
}

