/*
 * Decompiled with CFR 0.152.
 */
package com.jacky8399.fakesnow.v1_21_10_R1;

import com.comphenix.protocol.events.PacketEvent;
import com.jacky8399.fakesnow.Config;
import com.jacky8399.fakesnow.PacketListener;
import com.jacky8399.fakesnow.WeatherCache;
import com.jacky8399.fakesnow.WeatherType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.papermc.paper.antixray.ChunkPacketBlockController;
import io.papermc.paper.antixray.ChunkPacketInfo;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HexFormat;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.block.CraftBiome;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketListener_v1_21_10_R1
extends PacketListener {
    private static final boolean CHECK_MISMATCH = true;
    private static final boolean INSPECT_PALETTE = false;
    private static final Logger logger = LoggerFactory.getLogger((String)PacketListener_v1_21_10_R1.class.getSimpleName());
    private static final Field BUFFER_FIELD;
    private static final HexFormat HEX;
    private static final int STATES_ENTRIES = 4096;
    private static final int BIOMES_ENTRIES = 64;

    public PacketListener_v1_21_10_R1(Plugin plugin) {
        super(plugin);
    }

    private static PalettedContainer<Holder<net.minecraft.world.level.biome.Biome>>[] copyBiomes(LevelChunk nmsChunk, LevelChunkSection[] sections, WeatherCache.WorldCache worldCache) {
        int chunkX = nmsChunk.getPos().x;
        int chunkZ = nmsChunk.getPos().z;
        PalettedContainer[] arr = new PalettedContainer[sections.length];
        EnumMap<WeatherType, Holder> weatherToNmsBiomeMap = new EnumMap<WeatherType, Holder>(WeatherType.class);
        for (WeatherType weatherType : WeatherType.values()) {
            weatherToNmsBiomeMap.put(weatherType, CraftBiome.bukkitToMinecraftHolder((Biome)weatherType.biome));
        }
        WeatherCache.ChunkCache chunkCache = worldCache.getChunkCache(chunkX, chunkZ);
        WeatherType globalWeather = worldCache.globalWeather();
        for (int idx = 0; idx < sections.length; ++idx) {
            PalettedContainer container;
            WeatherType[] sectionCache;
            LevelChunkSection section = sections[idx];
            WeatherType[] weatherTypeArray = sectionCache = chunkCache != null ? chunkCache.getSectionCache(idx) : null;
            if (worldCache.isSectionUniform(chunkCache, idx)) {
                Holder uniformBiomeHolder = (Holder)weatherToNmsBiomeMap.get((Object)globalWeather);
                container = new PalettedContainer((Object)uniformBiomeHolder, nmsChunk.level.palettedContainerFactory().biomeStrategy(), null);
            } else {
                container = section.getBiomes().copy();
                if (sectionCache == null) continue;
                for (int j = 0; j < 4; ++j) {
                    int y = j << 2;
                    for (int i = 0; i < 4; ++i) {
                        int x = i << 2;
                        for (int k = 0; k < 4; ++k) {
                            int z = k << 2;
                            WeatherType blockWeather = sectionCache[WeatherCache.ChunkCache.getBlockIndex(x, y, z)];
                            if (blockWeather != null) {
                                container.set(i, j, k, (Object)((Holder)weatherToNmsBiomeMap.get((Object)blockWeather)));
                                continue;
                            }
                            if (globalWeather == null) continue;
                            container.set(i, j, k, (Object)((Holder)weatherToNmsBiomeMap.get((Object)globalWeather)));
                        }
                    }
                }
            }
            arr[idx] = container;
        }
        return arr;
    }

    private static LevelChunkSection[] copyChunkSections(LevelChunk nmsChunk, LevelChunkSection[] originalSections, WeatherCache.WorldCache worldCache) {
        LevelChunkSection[] fakeSections = new LevelChunkSection[originalSections.length];
        PalettedContainer<Holder<net.minecraft.world.level.biome.Biome>>[] fakeBiomes = PacketListener_v1_21_10_R1.copyBiomes(nmsChunk, originalSections, worldCache);
        for (int idx = 0; idx < originalSections.length; ++idx) {
            LevelChunkSection originalSection = originalSections[idx];
            fakeSections[idx] = new LevelChunkSection(originalSection.getStates(), fakeBiomes[idx]);
        }
        return fakeSections;
    }

    void updatePacketOld(PacketEvent event) {
        long startTime = System.nanoTime();
        Player player = event.getPlayer();
        World world = player.getWorld();
        if (world.getEnvironment() != World.Environment.NORMAL) {
            return;
        }
        ClientboundLevelChunkWithLightPacket packet = (ClientboundLevelChunkWithLightPacket)event.getPacket().getHandle();
        int x = packet.getX();
        int z = packet.getZ();
        WeatherCache.WorldCache worldCache = WeatherCache.getWorldCache(world);
        if (worldCache == null || !worldCache.hasChunk(x, z)) {
            return;
        }
        Chunk chunk = world.getChunkAt(x, z);
        LevelChunk nmsChunk = (LevelChunk)((CraftChunk)chunk).getHandle(ChunkStatus.FULL);
        ClientboundLevelChunkPacketData data = packet.getChunkData();
        long preprocessingTime = System.nanoTime();
        LevelChunkSection[] originalSections = nmsChunk.getSections();
        LevelChunkSection[] fakeSections = PacketListener_v1_21_10_R1.copyChunkSections(nmsChunk, originalSections, worldCache);
        long copyTime = System.nanoTime();
        ChunkPacketBlockController chunkPacketBlockController = nmsChunk.getLevel().chunkPacketBlockController;
        int newBufferSize = 0;
        for (LevelChunkSection section : fakeSections) {
            newBufferSize += section.getSerializedSize();
        }
        byte[] newBuffer = new byte[newBufferSize];
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])newBuffer);
        byteBuf.writerIndex(0);
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(byteBuf);
        int idx = 0;
        for (LevelChunkSection section : fakeSections) {
            ChunkPacketInfo info = chunkPacketBlockController.getChunkPacketInfo(packet, nmsChunk);
            if (info != null) {
                info.setBuffer(newBuffer);
            }
            section.write(friendlyByteBuf, info, idx++);
        }
        try {
            BUFFER_FIELD.set(data, newBuffer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        packet.setReady(true);
        long endTime = System.nanoTime();
        if (Config.debug) {
            logger.info("[Old] Chunk (%d, %d), preprocessing: %dns, copy: %dns, write buffer: %dns, total: %dns".formatted(x, z, preprocessingTime - startTime, copyTime - preprocessingTime, endTime - copyTime, endTime - startTime));
        }
    }

    private static int getRealSerializedSize(PalettedContainerRO<?> pc) {
        return pc.getSerializedSize();
    }

    void updatePacketNew(PacketEvent event) {
        byte[] buffer;
        Player player = event.getPlayer();
        World world = player.getWorld();
        ClientboundLevelChunkWithLightPacket packet = (ClientboundLevelChunkWithLightPacket)event.getPacket().getHandle();
        int x = packet.getX();
        int z = packet.getZ();
        WeatherCache.WorldCache worldCache = WeatherCache.getWorldCache(world);
        if (worldCache == null || !worldCache.hasChunk(x, z)) {
            return;
        }
        Chunk chunk = world.getChunkAt(x, z);
        LevelChunk nmsChunk = (LevelChunk)((CraftChunk)chunk).getHandle(ChunkStatus.FULL);
        ClientboundLevelChunkPacketData data = packet.getChunkData();
        LevelChunkSection[] originalSections = nmsChunk.getSections();
        try {
            buffer = (byte[])BUFFER_FIELD.get(data);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        byte[] expectedBuffer = null;
        long oldTime = 0L;
        if (Config.debug) {
            long oldStartTime = System.nanoTime();
            this.updatePacketOld(event);
            oldTime = System.nanoTime() - oldStartTime;
            try {
                expectedBuffer = (byte[])BUFFER_FIELD.get(data);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        long startTime = System.nanoTime();
        int numOfSections = originalSections.length;
        int newBufferSize = 0;
        PalettedContainer<Holder<net.minecraft.world.level.biome.Biome>>[] fakeBiomes = PacketListener_v1_21_10_R1.copyBiomes(nmsChunk, originalSections, worldCache);
        long copyTime = System.nanoTime();
        int[] statesSizes = new int[numOfSections];
        int[] biomesSizes = new int[numOfSections];
        int[] fakeBiomesSizes = new int[numOfSections];
        for (int i = 0; i < numOfSections; ++i) {
            LevelChunkSection section = originalSections[i];
            int statesSize = PacketListener_v1_21_10_R1.getRealSerializedSize(section.getStates());
            int fakeBiomesSize = PacketListener_v1_21_10_R1.getRealSerializedSize(fakeBiomes[i]);
            newBufferSize += 2 + statesSize + fakeBiomesSize;
            statesSizes[i] = statesSize;
            biomesSizes[i] = PacketListener_v1_21_10_R1.getRealSerializedSize(section.getBiomes());
            fakeBiomesSizes[i] = fakeBiomesSize;
        }
        byte[] newBuffer = new byte[newBufferSize];
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])newBuffer);
        byteBuf.writerIndex(0);
        int readIndex = 0;
        FriendlyByteBuf friendlyByteBuf = new FriendlyByteBuf(byteBuf);
        for (int i = 0; i < numOfSections; ++i) {
            int size = 2 + statesSizes[i];
            int writerIndex = byteBuf.writerIndex();
            System.arraycopy(buffer, readIndex, newBuffer, writerIndex, size);
            byteBuf.writerIndex(writerIndex + size);
            fakeBiomes[i].write(friendlyByteBuf);
            if (Config.debug) {
                int expectedSize = size + fakeBiomesSizes[i];
                int mismatch = Arrays.mismatch(expectedBuffer, writerIndex, writerIndex + expectedSize, newBuffer, writerIndex, writerIndex + expectedSize);
                StringBuilder builder = null;
                if (mismatch != -1) {
                    builder = new StringBuilder();
                    builder.append(ChatColor.AQUA).append("Chunk section at (").append(x).append(",").append(z).append("), i = ").append(i).append(ChatColor.RESET).append('\n');
                }
                if (mismatch != -1) {
                    builder.append("Mismatch at ").append(mismatch).append(" for statesSize=").append(statesSizes[i]).append(", biomesSize=").append(biomesSizes[i]).append(", fakeBiomesSize=").append(fakeBiomesSizes[i]).append("\nwhile copying buffer[").append(readIndex).append(":").append(readIndex + size).append("] to newBuffer[").append(writerIndex).append(":").append(writerIndex + size).append("]").append('\n');
                    builder.append("Expected: ");
                    PacketListener_v1_21_10_R1.printBytes(builder, expectedBuffer, writerIndex, writerIndex + expectedSize, writerIndex + mismatch, statesSizes[i]);
                    builder.append('\n');
                }
                if (mismatch != -1) {
                    builder.append("Original: ");
                    PacketListener_v1_21_10_R1.printBytes(builder, buffer, readIndex, readIndex + size + biomesSizes[i], readIndex + mismatch, statesSizes[i]);
                    builder.append('\n');
                    builder.append("Got:      ");
                    PacketListener_v1_21_10_R1.printBytes(builder, newBuffer, writerIndex, writerIndex + expectedSize, writerIndex + mismatch, statesSizes[i]);
                    builder.append("\nWriter index is at ").append(friendlyByteBuf.writerIndex());
                    Bukkit.getConsoleSender().sendMessage(builder.toString());
                }
            }
            readIndex += size + biomesSizes[i];
        }
        try {
            BUFFER_FIELD.set(data, newBuffer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        long endTime = System.nanoTime();
        if (Config.debug) {
            logger.info("[New] Chunk (%d, %d), copy: %dns, write: %dns, total: %dns".formatted(x, z, copyTime - startTime, endTime - copyTime, endTime - startTime));
            logger.info("vs old (%dns), speedup: %.2f".formatted(oldTime, (double)oldTime / (double)(endTime - startTime)));
            int mismatch = Arrays.mismatch(expectedBuffer, 0, newBufferSize, newBuffer, 0, newBufferSize);
            if (mismatch != -1) {
                logger.warn("Mismatch at byte " + mismatch + " (expected " + expectedBuffer[mismatch] + ", got " + newBuffer[mismatch] + ")");
                logger.warn("Blockstates sizes: " + Arrays.toString(statesSizes));
                logger.warn("Biomes sizes: " + Arrays.toString(biomesSizes));
                logger.warn("Fake biomes sizes: " + Arrays.toString(fakeBiomesSizes));
            }
        }
    }

    @Override
    public void onPacketSending(PacketEvent event) {
        if (Config.useFastPacketHandler) {
            try {
                this.updatePacketNew(event);
            }
            catch (Exception exception) {
                logger.warn("Fast packet handler exception, falling back", (Throwable)exception);
                this.updatePacketOld(event);
            }
        } else {
            this.updatePacketOld(event);
        }
    }

    private static void printBytesWithMismatch(StringBuilder a, byte[] arr, int from, int to, int mismatch) {
        if (mismatch >= from && mismatch < to) {
            HEX.formatHex(a, arr, from, mismatch);
            a.append(ChatColor.UNDERLINE);
            HEX.formatHex(a, arr, mismatch, to);
        } else {
            HEX.formatHex(a, arr, from, to);
        }
        a.append(ChatColor.RESET);
    }

    private static void printBytes(StringBuilder builder, byte[] arr, int from, int to, int mismatch, int statesSize) {
        builder.ensureCapacity(builder.length() + (to - from) * 2 + 14);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])arr).readerIndex(from);
        builder.append("\nNON_EMPTY: ").append(ChatColor.GREEN);
        PacketListener_v1_21_10_R1.printBytesWithMismatch(builder, arr, from, from + 2, mismatch);
        builder.append(String.valueOf(ChatColor.GRAY) + " = ").append(byteBuf.readShort()).append('\n');
        builder.append("STATES   : ").append(ChatColor.YELLOW);
        if (mismatch >= from + 2 && mismatch < from + 2 + statesSize) {
            PacketListener_v1_21_10_R1.printBytesWithMismatch(builder, arr, from + 2, from + 2 + statesSize, mismatch);
        } else {
            HEX.toHexDigits(builder, arr[from + 2]);
            builder.append("...");
            HEX.toHexDigits(builder, arr[from + 2 + statesSize - 1]);
        }
        builder.append(ChatColor.RESET).append('\n');
        builder.append("BIOMES   : ").append(ChatColor.LIGHT_PURPLE);
        PacketListener_v1_21_10_R1.printBytesWithMismatch(builder, arr, from + 2 + statesSize, to, mismatch);
        builder.append('\n').append(ChatColor.GRAY).append(" = ");
        byteBuf.skipBytes(statesSize);
        try {
            short bitsPerEntry = byteBuf.readUnsignedByte();
            builder.append("bitsPerEntry: ").append(bitsPerEntry).append("\npalette: ");
            switch (bitsPerEntry) {
                case 0: {
                    builder.append("Single-Valued (").append(VarInt.read((ByteBuf)byteBuf)).append(")");
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    int entries = VarInt.read((ByteBuf)byteBuf);
                    builder.append("Indirect (").append(entries).append(") {");
                    for (int i = 0; i < entries; ++i) {
                        int entry = VarInt.read((ByteBuf)byteBuf);
                        builder.append('\n').append(HEX.toHexDigits(i)).append(" -> ").append(HEX.toHexDigits(entry));
                    }
                    builder.append("\n}");
                    break;
                }
                case 6: {
                    builder.append("Direct");
                    break;
                }
                default: {
                    builder.append("UNKNOWN");
                }
            }
            if (bitsPerEntry != 0) {
                builder.append("\nValues: ");
                int longs = 64 * bitsPerEntry / 64;
                long mask = (1L << bitsPerEntry) - 1L;
                int hexDigits = bitsPerEntry / 4 + 1;
                for (int i = 0; i < longs; ++i) {
                    long l = byteBuf.readLong();
                    for (int j = 0; j < 64; j += bitsPerEntry) {
                        long value = l & mask;
                        builder.append(HEX.toHexDigits(value, hexDigits)).append(' ');
                        l >>= bitsPerEntry;
                    }
                }
            }
            builder.append(ChatColor.RESET);
        }
        catch (Exception ex) {
            logger.info("Failed to parse biome palette", (Throwable)ex);
        }
    }

    static {
        try {
            Field bufferField = null;
            for (Field field : ClientboundLevelChunkPacketData.class.getDeclaredFields()) {
                if (field.getType() != byte[].class) continue;
                bufferField = field;
                break;
            }
            if (bufferField == null) {
                throw new Error("Couldn't find byte[] buffer in ClientboundLevelChunkPacketData");
            }
            bufferField.setAccessible(true);
            BUFFER_FIELD = bufferField;
        }
        catch (Exception ex) {
            throw new Error("Couldn't find byte[] buffer in ClientboundLevelChunkPacketData", ex);
        }
        HEX = HexFormat.of().withUpperCase();
    }
}

