/*
 * Decompiled with CFR 0.152.
 */
package com.jacky8399.fakesnow;

import com.jacky8399.fakesnow.CacheHandler;
import com.jacky8399.fakesnow.Config;
import com.jacky8399.fakesnow.FakeSnow;
import com.jacky8399.fakesnow.WeatherCache;
import com.jacky8399.fakesnow.WeatherType;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.EnumFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.util.HashMap;
import java.util.logging.Logger;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public class WorldGuardCacheHandler
implements CacheHandler {
    private static final Logger LOGGER = FakeSnow.get().logger;
    public static EnumFlag<WeatherType> CUSTOM_WEATHER_TYPE;
    private static final int QUERY_OFFSET = 2;

    public static void tryAddFlag() {
        try {
            CUSTOM_WEATHER_TYPE = new EnumFlag("custom-weather-type", WeatherType.class);
            WorldGuard.getInstance().getFlagRegistry().register(CUSTOM_WEATHER_TYPE);
        }
        catch (Throwable e) {
            Flag flag = WorldGuard.getInstance().getFlagRegistry().get("custom-weather-type");
            FakeSnow.get().logger.warning("Detected existing WorldGuard flag 'custom-weather-type'.");
            CUSTOM_WEATHER_TYPE = (EnumFlag)flag;
        }
        FakeSnow.get().logger.info("Registered WorldGuard flag 'custom-weather-type'");
    }

    @Override
    @Nullable
    public WeatherCache.WorldCache loadWorld(World world) {
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return null;
        }
        ProtectedRegion globalRegion = regionManager.getRegion("__global__");
        WeatherType globalWeather = null;
        if (globalRegion != null) {
            globalWeather = (WeatherType)((Object)globalRegion.getFlag(CUSTOM_WEATHER_TYPE));
        }
        Chunk[] loadedChunks = world.getLoadedChunks();
        WeatherCache.WorldCache weatherCache = new WeatherCache.WorldCache(globalWeather, new HashMap<WeatherCache.ChunkPos, WeatherCache.ChunkCache>());
        for (Chunk chunk : loadedChunks) {
            WeatherCache.ChunkCache chunkCache = this.addChunkToCache(weatherCache, world, regionManager, chunk);
            if (chunkCache == null) continue;
            weatherCache.chunkMap().put(new WeatherCache.ChunkPos(chunk.getX(), chunk.getZ()), chunkCache);
        }
        return weatherCache;
    }

    public WeatherCache.ChunkCache addChunkToCache(WeatherCache.WorldCache cache, World world, RegionManager regionManager, Chunk chunk) {
        int xOffset = chunk.getX() * 16;
        int zOffset = chunk.getZ() * 16;
        int minHeight = world.getMinHeight();
        int maxHeight = world.getMaxHeight();
        WeatherType globalWeather = cache.globalWeather();
        long startTime = System.nanoTime();
        ProtectedCuboidRegion fakeRegion = new ProtectedCuboidRegion("dummy", true, BlockVector3.at((int)xOffset, (int)minHeight, (int)zOffset), BlockVector3.at((int)(xOffset + 15), (int)maxHeight, (int)(zOffset + 15)));
        ApplicableRegionSet chunkRegionSet = regionManager.getApplicableRegions((ProtectedRegion)fakeRegion, RegionQuery.QueryOption.COMPUTE_PARENTS);
        if (chunkRegionSet.isVirtual() || chunkRegionSet.size() == 0) {
            return null;
        }
        long chunkTime = System.nanoTime();
        WeatherType[][] chunkCache = new WeatherType[(maxHeight - minHeight) / 16][];
        boolean changed = false;
        for (ProtectedRegion region : chunkRegionSet) {
            WeatherType weatherType;
            if (!region.isPhysicalArea() || (weatherType = (WeatherType)((Object)region.getFlag(CUSTOM_WEATHER_TYPE))) == null || weatherType == globalWeather) continue;
            BlockVector3 minPoint = region.getMinimumPoint();
            BlockVector3 maxPoint = region.getMaximumPoint();
            int minY = minPoint.y() & 0xFFFFFFFC;
            int maxY = maxPoint.y() + 1 & 0xFFFFFFFC;
            int minX = Math.max(xOffset, minPoint.x()) & 0xF & 0xFFFFFFFC;
            int maxX = (Math.min(xOffset + 15, maxPoint.x()) & 0xF) + 4 & 0xFFFFFFFC;
            int minZ = Math.max(zOffset, minPoint.z()) & 0xF & 0xFFFFFFFC;
            int maxZ = (Math.min(zOffset + 15, maxPoint.z()) & 0xF) + 4 & 0xFFFFFFFC;
            if (Config.debug) {
                LOGGER.info("Region: %s, x: %d-%d, y: %d-%d, z: %d-%d".formatted(region.getId(), minX, maxX, minY, maxY, minZ, maxZ));
            }
            for (int y = minY; y < maxY; y += 4) {
                int sectionIndex = y - minHeight >> 4;
                WeatherType[] sectionCache = chunkCache[sectionIndex];
                if (sectionCache == null) {
                    chunkCache[sectionIndex] = new WeatherType[64];
                    sectionCache = chunkCache[sectionIndex];
                }
                for (int x = minX; x < maxX; x += 4) {
                    for (int z = minZ; z < maxZ; z += 4) {
                        if (!region.contains(xOffset + x + 2, y + 2, zOffset + z + 2)) continue;
                        sectionCache[(y & 0xF) << 2 | x | z >> 2] = weatherType;
                        changed = true;
                    }
                }
            }
        }
        long queryTime = System.nanoTime();
        if (changed) {
            if (Config.debug) {
                LOGGER.info("Caching chunk (%d, %d) (number of regions: %d): chunk query: %dns, updating cache: %dns".formatted(chunk.getX(), chunk.getZ(), chunkRegionSet.size(), chunkTime - startTime, queryTime - chunkTime));
            }
            return new WeatherCache.ChunkCache(chunkCache);
        }
        return null;
    }

    @Override
    public void unloadWorld(World world,  @Nullable WeatherCache.WorldCache cache) {
    }

    @Override
    @Nullable
    public WeatherCache.ChunkCache loadChunk(Chunk chunk, WeatherCache.WorldCache worldCache) {
        World world = chunk.getWorld();
        RegionManager regionManager = WorldGuard.getInstance().getPlatform().getRegionContainer().get(BukkitAdapter.adapt((World)world));
        if (regionManager == null) {
            return null;
        }
        return this.addChunkToCache(worldCache, world, regionManager, chunk);
    }

    @Override
    public void unloadChunk(Chunk chunk, WeatherCache.WorldCache worldCache,  @Nullable WeatherCache.ChunkCache chunkCache) {
    }
}

