/*
 * Decompiled with CFR 0.152.
 */
package com.jacky8399.fakesnow;

import com.jacky8399.fakesnow.CacheHandler;
import com.jacky8399.fakesnow.WeatherType;
import java.util.HashMap;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WeatherCache {
    static final WeakHashMap<World, WorldCache> worldCache = new WeakHashMap();

    public static void refreshCache(CacheHandler cacheHandler) {
        worldCache.clear();
        for (World world : Bukkit.getWorlds()) {
            worldCache.put(world, cacheHandler.loadWorld(world));
        }
    }

    @Nullable
    public static WorldCache getWorldCache(World world) {
        return worldCache.get(world);
    }

    public record WorldCache(@Nullable WeatherType globalWeather, @NotNull HashMap<ChunkPos, ChunkCache> chunkMap) {
        @Nullable
        public WeatherType getBlockWeather(World world, int chunkX, int chunkZ, int chunkPosX, int posY, int chunkPosZ) {
            ChunkCache chunkCache = this.getChunkCache(chunkX, chunkZ);
            if (chunkCache == null) {
                return null;
            }
            int minHeight = world.getMinHeight();
            int sectionIndex = posY - minHeight >> 4;
            WeatherType[] sectionCache = chunkCache.getSectionCache(sectionIndex);
            if (sectionCache == null) {
                return null;
            }
            return sectionCache[ChunkCache.getBlockIndex(chunkPosX, posY - minHeight & 0xF, chunkPosZ)];
        }

        @Nullable
        public WeatherType getBlockWeather(World world, int x, int y, int z) {
            return this.getBlockWeather(world, x >> 4, z >> 4, x & 0xF, y, z & 0xF);
        }

        public boolean isSectionUniform(@Nullable ChunkCache chunkCache, int sectionIndex) {
            if (this.globalWeather == null) {
                return false;
            }
            return chunkCache == null || chunkCache.getSectionCache(sectionIndex) == null;
        }

        public boolean hasChunk(int chunkX, int chunkZ) {
            return this.globalWeather != null || this.chunkMap.containsKey(new ChunkPos(chunkX, chunkZ));
        }

        @Nullable
        public ChunkCache getChunkCache(int chunkX, int chunkZ) {
            return this.chunkMap.get(new ChunkPos(chunkX, chunkZ));
        }

        public ChunkCache removeChunkCache(int chunkX, int chunkZ) {
            return this.chunkMap.remove(new ChunkPos(chunkX, chunkZ));
        }
    }

    public record ChunkCache(WeatherType[][] chunkCache) {
        public static int getBlockIndex(int x, int y, int z) {
            return ((y >>= 2) << 4) + ((x >>= 2) << 2) + (z >>= 2);
        }

        @Nullable
        public @Nullable WeatherType @Nullable [] getSectionCache(int sectionIndex) {
            return this.chunkCache[sectionIndex];
        }

        @Nullable
        public WeatherType getBlockWeather(int sectionIndex, int x, int y, int z) {
            WeatherType[] sectionCache = this.getSectionCache(sectionIndex);
            if (sectionCache != null) {
                return sectionCache[ChunkCache.getBlockIndex(x, y, z)];
            }
            return null;
        }
    }

    public record ChunkPos(int x, int z) {
        @Override
        public int hashCode() {
            int i = 1664525 * this.x + 1013904223;
            int j = 1664525 * (this.z ^ 0xDEADBEEF) + 1013904223;
            return i ^ j;
        }
    }
}

