/*
 * Decompiled with CFR 0.152.
 */
package com.jacky8399.fakesnow;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.jacky8399.fakesnow.CacheHandler;
import com.jacky8399.fakesnow.CommandFakesnow;
import com.jacky8399.fakesnow.Config;
import com.jacky8399.fakesnow.Events;
import com.jacky8399.fakesnow.WeatherCache;
import com.jacky8399.fakesnow.WorldGuardCacheHandler;
import com.jacky8399.fakesnow.bstats.bukkit.Metrics;
import com.jacky8399.fakesnow.v1_21_10_R1.PacketListener_v1_21_10_R1;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public final class FakeSnow
extends JavaPlugin {
    CacheHandler cacheHandler;
    private static FakeSnow INSTANCE;
    public Logger logger;
    private BukkitTask regionRefreshTask;
    private PacketListener packetListener;

    public void onLoad() {
        INSTANCE = this;
        this.logger = this.getLogger();
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            try {
                WorldGuardCacheHandler.tryAddFlag();
                this.cacheHandler = new WorldGuardCacheHandler();
            }
            catch (Error ex) {
                ex.printStackTrace();
            }
        }
    }

    public void onEnable() {
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        if (!MinecraftVersion.getCurrentVersion().isAtLeast(new MinecraftVersion("1.21"))) {
            throw new IllegalStateException("Only Minecraft 1.21.9-1.21.11 is supported");
        }
        if (!Stream.of("1.21.9", "1.21.10", "1.21.11").anyMatch(bukkitVersion::startsWith)) {
            throw new IllegalStateException("Unsupported version " + bukkitVersion);
        }
        this.packetListener = new PacketListener_v1_21_10_R1((Plugin)this);
        this.logger.info("Using " + this.packetListener.getClass().getSimpleName());
        Bukkit.getPluginManager().registerEvents((Listener)new Events(), (Plugin)this);
        this.getCommand("fakesnow").setExecutor((CommandExecutor)new CommandFakesnow());
        ProtocolLibrary.getProtocolManager().addPacketListener(this.packetListener);
        this.saveDefaultConfig();
        this.reloadConfig();
        if (this.cacheHandler == null) {
            this.cacheHandler = CacheHandler.ALWAYS_SNOWY;
            this.logger.info("WorldGuard not installed. All normal worlds will be snowy.");
        }
        WeatherCache.refreshCache(this.cacheHandler);
        new Metrics(this, 16697);
    }

    public void onDisable() {
        WeatherCache.worldCache.clear();
    }

    public void reloadConfig() {
        super.reloadConfig();
        Config.reloadConfig(this.getConfig());
        if (this.regionRefreshTask != null) {
            this.regionRefreshTask.cancel();
        }
        if (Config.regionRefreshInterval != 0) {
            this.regionRefreshTask = Bukkit.getScheduler().runTaskTimer((Plugin)this, () -> WeatherCache.refreshCache(this.cacheHandler), (long)Config.regionRefreshInterval * 20L, (long)Config.regionRefreshInterval * 20L);
        }
    }

    public static FakeSnow get() {
        return INSTANCE;
    }
}

