/*
 * Decompiled with CFR 0.152.
 */
package com.jacky8399.fakesnow;

import com.jacky8399.fakesnow.FakeSnow;
import com.jacky8399.fakesnow.WeatherCache;
import com.jacky8399.fakesnow.WeatherType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandFakesnow
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "You are running " + FakeSnow.get().getDescription().getFullName());
            return true;
        }
        switch (args[0]) {
            case "refreshregions": {
                Map<World, WeatherType> worldWeather = WeatherCache.worldCache.entrySet().stream().filter(entry -> ((WeatherCache.WorldCache)entry.getValue()).globalWeather() != null).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((WeatherCache.WorldCache)entry.getValue()).globalWeather()));
                WeatherCache.refreshCache(FakeSnow.get().cacheHandler);
                WeatherCache.worldCache.forEach((world, worldCache) -> {
                    WeatherType newWeather = worldCache.globalWeather();
                    if (newWeather != worldWeather.get(world)) {
                        for (Chunk chunk : world.getLoadedChunks()) {
                            world.refreshChunk(chunk.getX(), chunk.getZ());
                        }
                    } else {
                        for (WeatherCache.ChunkPos chunkPos : worldCache.chunkMap().keySet()) {
                            world.refreshChunk(chunkPos.x(), chunkPos.z());
                        }
                    }
                });
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reloaded " + Bukkit.getWorlds().size() + " worlds, cached " + WeatherCache.worldCache.values().stream().mapToInt(worldCache -> worldCache.chunkMap().size()).sum() + " chunks");
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "If you don't see the snow:\n" + String.valueOf(ChatColor.GREEN) + "1. Check if the biome is " + String.valueOf(WeatherType.SNOW.biome.getKey()) + "\n" + String.valueOf(ChatColor.GREEN) + "2. Check if the region is raining\n" + String.valueOf(ChatColor.YELLOW) + "  (You can lock a region's weather with " + String.valueOf(ChatColor.GOLD) + "/region flag <id> weather-lock rain" + String.valueOf(ChatColor.YELLOW) + ")\n" + String.valueOf(ChatColor.GREEN) + "3. Try relogging");
                return true;
            }
            case "realbiome": {
                Location location;
                if (args.length >= 4) {
                    try {
                        World world2;
                        World world3 = world2 = args.length == 5 ? Bukkit.getWorld((String)args[4]) : (World)Bukkit.getWorlds().get(0);
                        if (world2 == null) {
                            sender.sendMessage(String.valueOf(ChatColor.RED) + "World " + args[4] + " doesn't exist");
                            return true;
                        }
                        location = new Location(world2, (double)Integer.parseInt(args[1]), (double)Integer.parseInt(args[2]), (double)Integer.parseInt(args[3]));
                    }
                    catch (NumberFormatException e) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid coordinates " + String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length)));
                        return true;
                    }
                } else {
                    if (!(sender instanceof Player)) {
                        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /fakesnow realbiome <x> <y> <z> [world]");
                        return true;
                    }
                    location = ((Player)sender).getLocation();
                }
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "The actual biome at " + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ() + ": " + String.valueOf(location.getBlock().getBiome().getKey()));
                return true;
            }
            case "reload": {
                FakeSnow.get().reloadConfig();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded.");
                return true;
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /fakesnow <refreshregions/realbiome/reload>");
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length <= 1) {
            return List.of("refreshregions", "realbiome", "reload");
        }
        if ("realbiome".equals(args[0]) && args.length <= 5 && sender instanceof Player) {
            Player player = (Player)sender;
            Location location = player.getLocation();
            return Collections.singletonList(switch (args.length) {
                case 2 -> "" + location.getBlockX();
                case 3 -> "" + location.getBlockY();
                case 4 -> "" + location.getBlockZ();
                case 5 -> location.getWorld().getName();
                default -> throw new IllegalArgumentException();
            });
        }
        return List.of();
    }
}

