/*
 * Decompiled with CFR 0.152.
 */
package com.jacky8399.fakesnow;

import com.jacky8399.fakesnow.WeatherCache;
import com.jacky8399.fakesnow.WeatherType;
import java.util.HashMap;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.jetbrains.annotations.Nullable;

public interface CacheHandler {
    public static final CacheHandler ALWAYS_SNOWY = AlwaysSnowy.INSTANCE;

    @Nullable
    public WeatherCache.WorldCache loadWorld(World var1);

    public void unloadWorld(World var1, @Nullable WeatherCache.WorldCache var2);

    @Nullable
    public WeatherCache.ChunkCache loadChunk(Chunk var1, WeatherCache.WorldCache var2);

    public void unloadChunk(Chunk var1, WeatherCache.WorldCache var2, @Nullable WeatherCache.ChunkCache var3);

    public static class AlwaysSnowy
    implements CacheHandler {
        private static AlwaysSnowy INSTANCE = new AlwaysSnowy();

        private AlwaysSnowy() {
        }

        @Override
        @Nullable
        public WeatherCache.ChunkCache loadChunk(Chunk chunk, WeatherCache.WorldCache worldCache) {
            return null;
        }

        @Override
        public void unloadChunk(Chunk chunk, WeatherCache.WorldCache worldCache,  @Nullable WeatherCache.ChunkCache chunkCache) {
        }

        @Override
        @Nullable
        public WeatherCache.WorldCache loadWorld(World world) {
            if (world.getEnvironment() == World.Environment.NORMAL) {
                return new WeatherCache.WorldCache(WeatherType.SNOW, new HashMap<WeatherCache.ChunkPos, WeatherCache.ChunkCache>());
            }
            return null;
        }

        @Override
        public void unloadWorld(World world,  @Nullable WeatherCache.WorldCache cache) {
        }
    }
}

