/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.user;

import com.github.imdmk.spenttime.user.BukkitSpentTime;
import com.github.imdmk.spenttime.user.User;
import com.github.imdmk.spenttime.user.UserCache;
import com.github.imdmk.spenttime.user.repository.UserRepository;
import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UserService {
    private final Logger logger;
    private final UserRepository userRepository;
    private final UserCache userCache;
    private final BukkitSpentTime bukkitSpentTime;

    public UserService(@NotNull Logger logger, @NotNull UserRepository userRepository, @NotNull UserCache userCache, @NotNull BukkitSpentTime bukkitSpentTime) {
        this.logger = Objects.requireNonNull(logger, "logger cannot be null");
        this.userRepository = Objects.requireNonNull(userRepository, "userRepository cannot be null");
        this.userCache = Objects.requireNonNull(userCache, "userCache cannot be null");
        this.bukkitSpentTime = Objects.requireNonNull(bukkitSpentTime, "bukkitSpentTime cannot be null");
    }

    public CompletableFuture<User> findOrCreateUser(@NotNull Player player) {
        UUID uuid = player.getUniqueId();
        String name = player.getName();
        return ((CompletableFuture)this.userRepository.findByUUID(uuid).thenCompose(optionalUser -> optionalUser.map(CompletableFuture::completedFuture).orElseGet(() -> this.saveUser(new User(uuid, name))))).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "Failed to load user: " + name, (Throwable)throwable);
            return null;
        });
    }

    public void setSpentTime(@NotNull User user, Duration duration) {
        user.setSpentTime(duration);
        this.bukkitSpentTime.setSpentTime(user.getUuid(), duration);
        this.saveUser(user).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "An error occurred while setting spent time: " + String.valueOf(user), (Throwable)throwable);
            return null;
        });
    }

    public boolean updateUser(@NotNull Player player, @NotNull User user) {
        return this.updateUserData(player, user, this::saveUser);
    }

    public boolean updateUserData(@NotNull Player player, @NotNull User user, @Nullable Consumer<User> ifUpdated) {
        Duration spentTime;
        String oldName;
        boolean updated = false;
        String newName = player.getName();
        if (!newName.equals(oldName = user.getName())) {
            user.setName(newName);
            this.userCache.updateUserNameMapping(user, oldName);
            updated = true;
        }
        if (!(spentTime = this.bukkitSpentTime.getSpentTime((OfflinePlayer)player)).equals(user.getSpentTimeAsDuration())) {
            user.setSpentTime(spentTime);
            updated = true;
        }
        if (updated && ifUpdated != null) {
            ifUpdated.accept(user);
        }
        return updated;
    }

    public CompletableFuture<User> saveUser(@NotNull User user) {
        return this.userRepository.save(user).exceptionally(throwable -> {
            this.logger.log(Level.SEVERE, "Failed to save user '" + user.getName() + "'", (Throwable)throwable);
            throw new RuntimeException((Throwable)throwable);
        });
    }
}

