/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.user;

import com.github.imdmk.spenttime.plugin.lib.com.github.benmanes.caffeine.cache.Cache;
import com.github.imdmk.spenttime.plugin.lib.com.github.benmanes.caffeine.cache.Caffeine;
import com.github.imdmk.spenttime.user.User;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class UserCache {
    private static final Duration EXPIRE_AFTER_WRITE = Duration.ofHours(12L);
    private static final Duration EXPIRE_AFTER_ACCESS = Duration.ofHours(2L);
    private final Cache<UUID, User> cacheByUuid = Caffeine.newBuilder().expireAfterWrite(EXPIRE_AFTER_WRITE).expireAfterAccess(EXPIRE_AFTER_ACCESS).build();
    private final Cache<String, User> cacheByName = Caffeine.newBuilder().expireAfterWrite(EXPIRE_AFTER_WRITE).expireAfterAccess(EXPIRE_AFTER_ACCESS).build();

    public void cacheUser(@NotNull User user) {
        Objects.requireNonNull(user, "user cannot be null");
        this.cacheByUuid.put(user.getUuid(), user);
        this.cacheByName.put(user.getName(), user);
    }

    public void evictUser(@NotNull User user) {
        Objects.requireNonNull(user, "user cannot be null");
        this.cacheByUuid.invalidate(user.getUuid());
        this.cacheByName.invalidate(user.getName());
    }

    public void clearCache() {
        this.cacheByUuid.invalidateAll();
        this.cacheByName.invalidateAll();
    }

    @NotNull
    public Optional<User> getUserByUuid(@NotNull UUID uuid) {
        Objects.requireNonNull(uuid, "uuid cannot be null");
        return Optional.ofNullable(this.cacheByUuid.getIfPresent(uuid));
    }

    @NotNull
    public Optional<User> getUserByName(@NotNull String name) {
        Objects.requireNonNull(name, "name cannot be null");
        return Optional.ofNullable(this.cacheByName.getIfPresent(name));
    }

    public void forEachUser(@NotNull Consumer<User> updateAction) {
        Objects.requireNonNull(updateAction, "updateAction cannot be null");
        this.cacheByUuid.asMap().values().forEach(updateAction);
    }

    public void updateUserNameMapping(@NotNull User user, @NotNull String oldName) {
        Objects.requireNonNull(user, "user cannot be null");
        Objects.requireNonNull(oldName, "oldName cannot be null");
        this.cacheByName.invalidate(oldName);
        this.cacheByName.put(user.getName(), user);
    }

    @NotNull
    public Collection<String> getAllCachedUserNames() {
        return Collections.unmodifiableCollection(this.cacheByName.asMap().keySet());
    }
}

