/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.user;

import java.time.Duration;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class User {
    private final UUID uuid;
    private String name;
    private long spentTime = 0L;

    public User(@NotNull UUID uuid, @NotNull String name) {
        this.uuid = uuid;
        this.name = name;
    }

    public User(@NotNull UUID uuid, @NotNull String name, long spentTime) {
        this.uuid = uuid;
        this.name = name;
        this.spentTime = spentTime;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public long getSpentTime() {
        return this.spentTime;
    }

    @NotNull
    public Duration getSpentTimeAsDuration() {
        return Duration.ofMillis(this.spentTime);
    }

    public void setSpentTime(long spentTime) {
        this.spentTime = spentTime;
    }

    public void setSpentTime(@NotNull Duration spentTime) {
        this.spentTime = spentTime.toMillis();
    }

    public String toString() {
        return "User{uuid=" + String.valueOf(this.uuid) + ", name='" + this.name + "', spentTime=" + this.spentTime + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return Objects.equals(this.uuid, user.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }
}

