/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.shared;

import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.adventure.PlainComponentSerializer;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.text.Component;
import com.github.imdmk.spenttime.util.ComponentUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class Formatter {
    private static final PlainComponentSerializer PLAIN_SERIALIZER = new PlainComponentSerializer();
    private final Map<String, String> placeholders = new LinkedHashMap<String, String>();

    @Contract(value="_,_->this")
    public Formatter placeholder(@NotNull String from, @NotNull String to) {
        this.placeholders.put(from, to);
        return this;
    }

    @Contract(value="_,_->this")
    public Formatter placeholder(@NotNull String from, @NotNull Iterable<? extends CharSequence> sequences) {
        return this.placeholder(from, String.join((CharSequence)", ", sequences));
    }

    @Contract(value="_,_->this")
    public <T> Formatter placeholder(@NotNull String from, @NotNull T to) {
        return this.placeholder(from, to.toString());
    }

    @Contract(value="_,_->this")
    public Formatter placeholder(@NotNull String from, @NotNull Component to) {
        return this.placeholder(from, PLAIN_SERIALIZER.serialize(to));
    }

    @NotNull
    public Component format(@NotNull Component component) {
        for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
            String placeholder = entry.getKey();
            Component replacement = ComponentUtil.text(entry.getValue());
            component = component.replaceText(builder -> builder.matchLiteral(placeholder).replacement(replacement));
        }
        return component;
    }

    @NotNull
    public List<Component> format(@NotNull List<Component> component) {
        ArrayList<Component> replaced = new ArrayList<Component>();
        for (Component replacement : component) {
            replaced.add(this.format(replacement));
        }
        return replaced;
    }
}

