/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.validator;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.Preconditions;
import org.jetbrains.annotations.Nullable;

public class ValidatorResult {
    private final boolean valid;
    private final boolean canBeIgnored;
    @Nullable
    private final Object invalidResult;

    private ValidatorResult(boolean valid, boolean canBeIgnored, @Nullable Object invalidResult) {
        this.valid = valid;
        this.canBeIgnored = canBeIgnored;
        this.invalidResult = invalidResult;
    }

    public boolean isInvalid() {
        return !this.valid;
    }

    public boolean canBeIgnored() {
        return this.canBeIgnored;
    }

    public boolean hasInvalidResult() {
        return this.invalidResult != null;
    }

    public Object getInvalidResult() {
        Preconditions.checkArgument(!this.valid, "Command is valid", new Object[0]);
        Preconditions.notNull(this.invalidResult, "invalid result");
        return this.invalidResult;
    }

    public static ValidatorResult valid() {
        return new ValidatorResult(true, false, null);
    }

    public static ValidatorResult invalid(Object invalidResult) {
        return new ValidatorResult(false, false, invalidResult);
    }

    public static ValidatorResult invalid(Object invalidResult, boolean canBeIgnored) {
        return new ValidatorResult(false, canBeIgnored, invalidResult);
    }
}

