/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.util;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.reflect.ReflectUtil;
import java.util.Map;
import java.util.Optional;

public final class MapUtil {
    private MapUtil() {
    }

    public static <E> Optional<E> findByInstanceOf(Class<?> type, Map<Class<?>, E> map) {
        E element = map.get(type);
        if (element != null) {
            return Optional.of(element);
        }
        for (Map.Entry<Class<?>, E> entry : map.entrySet()) {
            if (!type.isAssignableFrom(entry.getKey())) continue;
            return Optional.ofNullable(entry.getValue());
        }
        return Optional.empty();
    }

    public static <E> Optional<E> findBySuperTypeOf(Class<?> type, Map<Class<?>, E> map) {
        Optional<E> optional;
        if (type.isArray() && (optional = MapUtil.findBySuperTypeOfArray(type.getComponentType(), map)).isPresent()) {
            return optional;
        }
        Optional<E> option = MapUtil.findKeySuperTypeOf0(type, map);
        if (option.isPresent()) {
            return option;
        }
        for (Class<?> anInterface : ReflectUtil.getInterfaces(type)) {
            E element = map.get(anInterface);
            if (element == null) continue;
            return Optional.of(element);
        }
        return MapUtil.findKeySuperTypeOf0(Object.class, map);
    }

    private static <E> Optional<E> findKeySuperTypeOf0(Class<?> type, Map<Class<?>, E> map) {
        Optional<E> option;
        E element = map.get(type);
        if (element != null) {
            return Optional.of(element);
        }
        Class<?> superclass = type.getSuperclass();
        if (superclass != null && superclass != Object.class && (option = MapUtil.findBySuperTypeOf(superclass, map)).isPresent()) {
            return option;
        }
        return Optional.empty();
    }

    private static <E> Optional<E> findBySuperTypeOfArray(Class<?> componentType, Map<Class<?>, E> map) {
        Optional<E> optional = MapUtil.findBySuperTypeOfArray0(componentType, map);
        if (optional.isPresent()) {
            return optional;
        }
        for (Class<?> anInterface : ReflectUtil.getInterfaces(componentType)) {
            Class<?> arrayType = ReflectUtil.getArrayType(anInterface);
            E element = map.get(arrayType);
            if (element == null) continue;
            return Optional.of(element);
        }
        return MapUtil.findBySuperTypeOfArray0(Object.class, map);
    }

    private static <E> Optional<E> findBySuperTypeOfArray0(Class<?> componentType, Map<Class<?>, E> map) {
        Optional<E> option;
        Class<?> arrayType = ReflectUtil.getArrayType(componentType);
        E element = map.get(arrayType);
        if (element != null) {
            return Optional.of(element);
        }
        Class<?> superclass = componentType.getSuperclass();
        if (superclass != null && superclass != Object.class && (option = MapUtil.findBySuperTypeOfArray0(superclass, map)).isPresent()) {
            return option;
        }
        return Optional.empty();
    }
}

