/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.time;

import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;

public abstract class TemporalAmountParser<T extends TemporalAmount> {
    private static final Map<ChronoUnit, Long> UNIT_TO_NANO = new LinkedHashMap<ChronoUnit, Long>();
    private static final Map<ChronoUnit, Integer> PART_TIME_UNITS = new LinkedHashMap<ChronoUnit, Integer>();
    private final Map<String, ChronoUnit> units = new LinkedHashMap<String, ChronoUnit>();
    private final LocalDateTimeProvider baseForTimeEstimation;

    protected TemporalAmountParser(LocalDateTimeProvider baseForTimeEstimation) {
        this.baseForTimeEstimation = baseForTimeEstimation;
    }

    protected TemporalAmountParser(Map<String, ChronoUnit> units, LocalDateTimeProvider baseForTimeEstimation) {
        this.baseForTimeEstimation = baseForTimeEstimation;
        this.units.putAll(units);
    }

    public TemporalAmountParser<T> withUnit(String symbol, ChronoUnit chronoUnit) {
        if (this.units.containsKey(symbol)) {
            throw new IllegalArgumentException("Symbol " + symbol + " is already used");
        }
        if (!this.validCharacters(symbol, Character::isLetter)) {
            throw new IllegalArgumentException("Symbol " + symbol + " contains non-letter characters");
        }
        LinkedHashMap<String, ChronoUnit> newUnits = new LinkedHashMap<String, ChronoUnit>(this.units);
        newUnits.put(symbol, chronoUnit);
        return this.clone(newUnits, this.baseForTimeEstimation);
    }

    public TemporalAmountParser<T> withLocalDateTimeProvider(LocalDateTimeProvider baseForTimeEstimation) {
        return this.clone(this.units, baseForTimeEstimation);
    }

    protected abstract TemporalAmountParser<T> clone(Map<String, ChronoUnit> var1, LocalDateTimeProvider var2);

    private boolean validCharacters(String content, Predicate<Character> predicate) {
        for (int i = 0; i < content.length(); ++i) {
            if (predicate.test(Character.valueOf(content.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public T parse(String input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Input is empty");
        }
        T total = this.getZero();
        boolean negative = false;
        StringBuilder number = new StringBuilder();
        StringBuilder unit = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '-') {
                if (i != 0) {
                    throw new IllegalArgumentException("Minus sign is only allowed at the start of the input");
                }
                negative = true;
                continue;
            }
            if (Character.isDigit(c)) {
                number.append(c);
                continue;
            }
            if (!Character.isLetter(c)) {
                throw new IllegalArgumentException("Invalid character " + c + " in input");
            }
            unit.append(c);
            if (i != input.length() - 1 && !Character.isDigit(input.charAt(i + 1))) continue;
            TemporalEntry temporalEntry = this.parseTemporal(number.toString(), unit.toString());
            total = this.plus(this.baseForTimeEstimation, total, temporalEntry);
            number.setLength(0);
            unit.setLength(0);
        }
        if (number.length() > 0 || unit.length() > 0) {
            throw new IllegalArgumentException("Input is not in the format of <number><unit>");
        }
        if (negative) {
            total = this.negate(total);
        }
        return total;
    }

    protected abstract T plus(LocalDateTimeProvider var1, T var2, TemporalEntry var3);

    protected abstract T negate(T var1);

    protected abstract T getZero();

    private TemporalEntry parseTemporal(String number, String unit) {
        if (number.isEmpty()) {
            throw new IllegalArgumentException("Missing number before unit " + unit);
        }
        ChronoUnit chronoUnit = this.units.get(unit);
        if (chronoUnit == null) {
            throw new IllegalArgumentException("Unknown unit " + unit);
        }
        try {
            long count = Long.parseLong(number);
            return new TemporalEntry(count, chronoUnit);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number " + number);
        }
    }

    public String format(T temporalAmount) {
        StringBuilder builder = new StringBuilder();
        Duration duration = this.toDuration(this.baseForTimeEstimation, temporalAmount);
        if (duration.isNegative()) {
            builder.append('-');
            duration = duration.negated();
        }
        ArrayList<String> keys = new ArrayList<String>(this.units.keySet());
        Collections.reverse(keys);
        for (String key : keys) {
            BigInteger maxCount;
            BigInteger count;
            ChronoUnit chronoUnit = this.units.get(key);
            Long part = UNIT_TO_NANO.get(chronoUnit);
            if (part == null) {
                throw new IllegalArgumentException("Unsupported unit " + chronoUnit);
            }
            BigInteger currentCount = this.durationToNano(duration).divide(BigInteger.valueOf(part));
            BigInteger bigInteger = count = currentCount.equals(maxCount = BigInteger.valueOf(PART_TIME_UNITS.get(chronoUnit).intValue())) ? BigInteger.ONE : currentCount.mod(maxCount);
            if (count.equals(BigInteger.ZERO)) continue;
            builder.append(count).append(key);
            duration = duration.minusNanos(count.longValue() * part);
        }
        return builder.toString();
    }

    protected abstract Duration toDuration(LocalDateTimeProvider var1, T var2);

    BigInteger durationToNano(Duration duration) {
        return BigInteger.valueOf(duration.getSeconds()).multiply(BigInteger.valueOf(1000000000L)).add(BigInteger.valueOf(duration.getNano()));
    }

    static {
        UNIT_TO_NANO.put(ChronoUnit.NANOS, 1L);
        UNIT_TO_NANO.put(ChronoUnit.MICROS, 1000L);
        UNIT_TO_NANO.put(ChronoUnit.MILLIS, 1000000L);
        UNIT_TO_NANO.put(ChronoUnit.SECONDS, 1000000000L);
        UNIT_TO_NANO.put(ChronoUnit.MINUTES, 60000000000L);
        UNIT_TO_NANO.put(ChronoUnit.HOURS, 3600000000000L);
        UNIT_TO_NANO.put(ChronoUnit.DAYS, 86400000000000L);
        UNIT_TO_NANO.put(ChronoUnit.WEEKS, 604800000000000L);
        UNIT_TO_NANO.put(ChronoUnit.MONTHS, 2592000000000000L);
        UNIT_TO_NANO.put(ChronoUnit.YEARS, 31536000000000000L);
        UNIT_TO_NANO.put(ChronoUnit.DECADES, 315360000000000000L);
        PART_TIME_UNITS.put(ChronoUnit.NANOS, 1000);
        PART_TIME_UNITS.put(ChronoUnit.MICROS, 1000);
        PART_TIME_UNITS.put(ChronoUnit.MILLIS, 1000);
        PART_TIME_UNITS.put(ChronoUnit.SECONDS, 60);
        PART_TIME_UNITS.put(ChronoUnit.MINUTES, 60);
        PART_TIME_UNITS.put(ChronoUnit.HOURS, 24);
        PART_TIME_UNITS.put(ChronoUnit.DAYS, 7);
        PART_TIME_UNITS.put(ChronoUnit.WEEKS, 4);
        PART_TIME_UNITS.put(ChronoUnit.MONTHS, 12);
        PART_TIME_UNITS.put(ChronoUnit.YEARS, Integer.MAX_VALUE);
    }

    public static interface LocalDateTimeProvider {
        public LocalDateTime get();

        public static LocalDateTimeProvider now() {
            return LocalDateTime::now;
        }

        public static LocalDateTimeProvider startOfToday() {
            return LocalDateTimeProvider.of(LocalDate.now());
        }

        public static LocalDateTimeProvider of(LocalDateTime localDateTime) {
            return () -> localDateTime;
        }

        public static LocalDateTimeProvider of(LocalDate localDate) {
            return localDate::atStartOfDay;
        }
    }

    protected static class TemporalEntry {
        private final long count;
        private final ChronoUnit unit;

        public TemporalEntry(long count, ChronoUnit unit) {
            this.count = count;
            this.unit = unit;
        }

        public long getCount() {
            return this.count;
        }

        public ChronoUnit getUnit() {
            return this.unit;
        }
    }
}

