/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.Parser;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParserRegistry;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.suggester.Suggester;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.suggester.SuggesterRegistry;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.suggester.input.SuggestionInputMatcher;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.suggester.input.SuggestionInputResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.command.CommandRoute;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.command.executor.CommandExecutor;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.flow.Flow;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.Suggestion;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.util.StringUtil;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.validator.ValidatorService;

public class SuggestionService<SENDER> {
    private final ParserRegistry<SENDER> parserRegistry;
    private final SuggesterRegistry<SENDER> suggesterRegistry;
    private final ValidatorService<SENDER> validatorService;

    public SuggestionService(ParserRegistry<SENDER> parserRegistry, SuggesterRegistry<SENDER> suggesterRegistry, ValidatorService<SENDER> validatorService) {
        this.parserRegistry = parserRegistry;
        this.suggesterRegistry = suggesterRegistry;
        this.validatorService = validatorService;
    }

    public SuggestionResult suggest(Invocation<SENDER> invocation, SuggestionInputMatcher<?> matcher, CommandRoute<SENDER> commandRoute) {
        return this.suggest0(invocation, matcher, commandRoute);
    }

    private <MATCHER extends SuggestionInputMatcher<MATCHER>> SuggestionResult suggest0(Invocation<SENDER> invocation, SuggestionInputMatcher<MATCHER> matcher, CommandRoute<SENDER> commandRoute) {
        if (matcher.hasNoNextRouteAndArguments()) {
            Flow flow = this.validatorService.validate(invocation, commandRoute);
            if (flow.isTerminate() || flow.isStopCurrent()) {
                return SuggestionResult.empty();
            }
            return SuggestionResult.of(commandRoute.names());
        }
        SuggestionResult all = SuggestionResult.empty();
        for (CommandExecutor commandExecutor : commandRoute.getExecutors()) {
            Flow flow = this.validatorService.validate(invocation, commandExecutor);
            if (flow.isTerminate() || flow.isStopCurrent()) continue;
            SuggestionResult result = this.suggestExecutor(invocation, matcher.copy(), commandExecutor);
            all.addAll(result.getSuggestions());
        }
        if (!matcher.nextRouteIsLast()) {
            return all;
        }
        String current = matcher.showNextRoute();
        for (CommandRoute<SENDER> child : commandRoute.getChildren()) {
            if (!this.isAnyExecutorValid(invocation, child)) continue;
            for (String name : child.names()) {
                if (!StringUtil.startsWithIgnoreCase(name, current)) continue;
                all.add(Suggestion.of(name));
            }
        }
        return all;
    }

    private boolean isAnyExecutorValid(Invocation<SENDER> invocation, CommandRoute<SENDER> route) {
        Flow flow = this.validatorService.validate(invocation, route);
        if (flow.isTerminate() || flow.isStopCurrent()) {
            return false;
        }
        for (CommandExecutor commandExecutor : route.getExecutors()) {
            Flow flowExecutor = this.validatorService.validate(invocation, commandExecutor);
            if (flowExecutor.isTerminate() || flowExecutor.isStopCurrent()) continue;
            return true;
        }
        for (CommandRoute commandRoute : route.getChildren()) {
            if (!this.isAnyExecutorValid(invocation, commandRoute)) continue;
            return true;
        }
        return false;
    }

    public <MATCHER extends SuggestionInputMatcher<MATCHER>> SuggestionResult suggestExecutor(Invocation<SENDER> invocation, MATCHER matcher, CommandExecutor<SENDER> executor) {
        SuggestionResult collector = SuggestionResult.empty();
        block5: for (Argument<?> argument : executor.getArguments()) {
            SuggestionInputResult result = this.suggestArgument(invocation, matcher, argument);
            collector.addAll(result.getResult());
            switch (result.getCause()) {
                case CONTINUE: {
                    continue block5;
                }
                case END: {
                    return collector;
                }
                case FAIL: {
                    return SuggestionResult.empty();
                }
            }
        }
        return collector;
    }

    private <PARSED, MATCHER extends SuggestionInputMatcher<MATCHER>> SuggestionInputResult suggestArgument(Invocation<SENDER> invocation, MATCHER matcher, Argument<PARSED> argument) {
        Suggester suggester;
        Class parsedType = argument.getType().getRawType();
        Parser<SENDER, PARSED> parser = this.parserRegistry.getParser(argument);
        SuggestionInputResult result = matcher.nextArgument(invocation, argument, parser, suggester = this.suggesterRegistry.getSuggester(parsedType, argument.getKey()));
        if (result.isEnd() && matcher.isOptionalArgument(invocation, argument, parser)) {
            return SuggestionInputResult.continueWith(result);
        }
        return result;
    }
}

