/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.scheduler;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class SchedulerPoll {
    public static final SchedulerPoll MAIN = new SchedulerPoll("main", new SchedulerPoll[0]);
    public static final SchedulerPoll ASYNCHRONOUS = new SchedulerPoll("async", MAIN);
    public static final SchedulerPoll COMPLETABLE_FUTURE = new SchedulerPoll("completable_future", ASYNCHRONOUS);
    public static final SchedulerPoll EXECUTOR = new SchedulerPoll("executor", MAIN);
    public static final SchedulerPoll SUGGESTER = new SchedulerPoll("suggester", ASYNCHRONOUS);
    private final String name;
    private final Set<SchedulerPoll> replaceable = new HashSet<SchedulerPoll>();
    private final boolean logging;

    protected SchedulerPoll(String name, SchedulerPoll ... replaceable) {
        this(name, false, replaceable);
    }

    protected SchedulerPoll(String name, boolean logging, SchedulerPoll ... replaceable) {
        this.name = name;
        this.replaceable.addAll(Arrays.asList(replaceable));
        this.logging = logging;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public SchedulerPoll logging() {
        return new SchedulerPoll(this.name, true, this.replaceable.toArray(new SchedulerPoll[0]));
    }

    public SchedulerPoll resolve(SchedulerPoll ... available) {
        return this.resolve(Arrays.asList(available));
    }

    public SchedulerPoll resolve(Collection<SchedulerPoll> available) {
        if (available.isEmpty()) {
            throw new IllegalStateException("Cannot resolve the thread type");
        }
        if (available.contains(this)) {
            return this;
        }
        for (SchedulerPoll poll : this.replaceable) {
            if (!available.contains(poll)) continue;
            return poll;
        }
        for (SchedulerPoll poll : this.replaceable) {
            SchedulerPoll resolve = poll.resolve(available);
            if (resolve == null) continue;
            return resolve;
        }
        throw new IllegalStateException("Cannot resolve the thread type");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchedulerPoll that = (SchedulerPoll)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String toString() {
        return "SchedulerPoll{name='" + this.name + '\'' + ", logging=" + this.logging + '}';
    }
}

