/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.scheduler;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.scheduler.Scheduler;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.scheduler.SchedulerPoll;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.ThrowingSupplier;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractMainThreadBasedScheduler
implements Scheduler {
    @Override
    public final <T> CompletableFuture<T> supplyLater(SchedulerPoll type, Duration delay, ThrowingSupplier<T, Throwable> supplier) {
        SchedulerPoll resolved = type.resolve(SchedulerPoll.MAIN, SchedulerPoll.ASYNCHRONOUS);
        CompletableFuture future = new CompletableFuture();
        if (resolved.equals(SchedulerPoll.MAIN)) {
            this.runSynchronous(() -> this.tryRun(type, future, supplier), delay);
            return future;
        }
        if (resolved.equals(SchedulerPoll.ASYNCHRONOUS)) {
            this.runAsynchronous(() -> this.tryRun(type, future, supplier), delay);
            return future;
        }
        throw new IllegalArgumentException("Unknown scheduler poll type: " + type);
    }

    protected abstract void runSynchronous(Runnable var1, Duration var2);

    protected abstract void runAsynchronous(Runnable var1, Duration var2);

    private <T> void tryRun(SchedulerPoll type, CompletableFuture<T> future, ThrowingSupplier<T, Throwable> supplier) {
        block2: {
            try {
                future.complete(supplier.get());
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
                if (!type.isLogging()) break block2;
                this.log(throwable);
            }
        }
    }

    protected void log(Throwable throwable) {
    }
}

