/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.prettyprint;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintAnnotation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintIndent;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintModifier;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintParameter;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintPicker;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.prettyprint.PrettyPrintType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class PrettyPrintMethod {
    private static final String METHOD_PATTERN = "{annotations}{modifiers}{generic}{type} {name}({parameters}) {\n{indentedContent}\n}";
    private static final String PARAMETER_PATTERN = "{annotations}{type} {name}";
    private static final Map<Parameter, Annotation[]> parameterAnnotationsCache = new WeakHashMap<Parameter, Annotation[]>();

    public static String formatMethod(Method method, PrettyPrintPicker picker, String content) {
        return PrettyPrintMethod.formatMethod(method, -1, picker, content);
    }

    public static String formatMethod(Method method, Parameter parameter, String content) {
        return PrettyPrintMethod.formatMethod(method, PrettyPrintParameter.getParameterIndex(method, parameter), PrettyPrintPicker.PARAMETER, content);
    }

    private static String formatMethod(Method method, int parameter, PrettyPrintPicker picker, String content) {
        String annotations = PrettyPrintAnnotation.formatAnnotations(method.getAnnotations(), "\n", "\n");
        String modifiers = PrettyPrintModifier.formatModifiers(method.getModifiers());
        String generic = PrettyPrintType.formatGeneric(method.getTypeParameters());
        String type = PrettyPrintType.formatType(method.getGenericReturnType());
        String name = method.getName();
        List<String> formattedParameters = PrettyPrintParameter.formatParameters(method.getParameters());
        String parameters = PrettyPrintParameter.formatParameters(formattedParameters);
        int additional = 0;
        if (picker == PrettyPrintPicker.EXECUTABLE) {
            additional = modifiers.length() + generic.length() + type.length() + " ".length();
        }
        if (picker == PrettyPrintPicker.PARAMETER && parameter != -1) {
            String pickedParameters = PrettyPrintParameter.formatParameters(formattedParameters.subList(0, parameter));
            additional = modifiers.length() + generic.length() + type.length() + " ".length() + name.length() + pickedParameters.length() + " ".length();
        }
        String indentedContent = PrettyPrintIndent.indentedContent(content, additional);
        return METHOD_PATTERN.replace("{annotations}", annotations).replace("{modifiers}", modifiers).replace("{generic}", generic).replace("{type}", type).replace("{name}", name).replace("{parameters}", parameters).replace("{indentedContent}", indentedContent);
    }
}

