/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.meta;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.meta.MetaType;
import org.jetbrains.annotations.Nullable;

public class MetaKey<T> {
    private final String key;
    private final MetaType<T> type;
    @Nullable
    private final T defaultValue;

    protected MetaKey(String key, MetaType<T> type, @Nullable T defaultValue) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public String getKey() {
        return this.key;
    }

    public MetaType<T> getType() {
        return this.type;
    }

    @Nullable
    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public static <T> MetaKey<T> of(String key, Class<T> type) {
        return new MetaKey<Object>(key, MetaType.of(type), null);
    }

    public static <T> MetaKey<T> of(String key, Class<T> type, T defaultValue) {
        return MetaKey.of(key, MetaType.of(type), defaultValue);
    }

    public static <T> MetaKey<T> of(String key, MetaType<T> type) {
        return MetaKey.of(key, type, null);
    }

    public static <T> MetaKey<T> of(String key, MetaType<T> type, T defaultValue) {
        return new MetaKey<T>(key, type, defaultValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaKey that = (MetaKey)o;
        return this.key.equals(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        return "MetaKey{key='" + this.key + '\'' + ", type=" + this.type + ", defaultValue=" + this.defaultValue + '}';
    }
}

