/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.literal;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.profile.ArgumentProfile;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.profile.ArgumentProfileNamespace;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.meta.MetaKey;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.range.Range;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.Preconditions;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.util.LiteCommandsUtil;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.util.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class LiteralProfile
implements ArgumentProfile<LiteralProfile> {
    public static final ArgumentProfileNamespace<LiteralProfile> NAMESPACE = ArgumentProfileNamespace.of(MetaKey.of("profile:literal", LiteralProfile.class));
    private final Set<String> literals;
    private final Range expectedRange;

    public LiteralProfile(Collection<String> literals, boolean caseInsensitive) {
        Preconditions.notEmpty(literals, "literals");
        LiteCommandsUtil.checkAliases(literals);
        this.literals = LiteralProfile.createSet(literals, caseInsensitive);
        this.expectedRange = LiteralProfile.calculateExpectedRange(literals);
    }

    public LiteralProfile(String[] literals, boolean caseInsensitive) {
        this(Arrays.asList(literals), caseInsensitive);
    }

    public Set<String> getLiterals() {
        return this.literals;
    }

    public Range getExpectedRange() {
        return this.expectedRange;
    }

    @Override
    public ArgumentProfileNamespace<LiteralProfile> getNamespace() {
        return NAMESPACE;
    }

    public static LiteralProfile of(Collection<String> literals) {
        return new LiteralProfile(literals, false);
    }

    public static LiteralProfile of(String ... literals) {
        return new LiteralProfile(literals, false);
    }

    public static LiteralProfile ofIgnoreCase(Collection<String> literals) {
        return new LiteralProfile(literals, true);
    }

    public static LiteralProfile ofIgnoreCase(String ... literals) {
        return new LiteralProfile(literals, true);
    }

    private static Set<String> createSet(Collection<String> literals, boolean caseInsensitive) {
        TreeSet<String> set = caseInsensitive ? new TreeSet<String>(String.CASE_INSENSITIVE_ORDER) : new TreeSet();
        set.addAll(literals);
        return Collections.unmodifiableSortedSet(set);
    }

    private static Range calculateExpectedRange(Collection<String> literals) {
        int min2 = -1;
        int max = -1;
        for (String literal : literals) {
            int spaces = StringUtil.countOf(literal, ' ') + 1;
            if (min2 == -1 && max == -1) {
                min2 = spaces;
                max = spaces;
                continue;
            }
            min2 = Math.min(min2, spaces);
            max = Math.max(max, spaces);
        }
        return Range.range(min2, max);
    }
}

