/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.literal;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.profile.ProfileNamespaces;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.profile.ProfiledMultipleArgumentResolver;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.input.raw.RawInput;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.literal.LiteralProfile;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.range.Range;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.FailedReason;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.util.ArrayList;
import java.util.List;

public class LiteralArgumentResolver<SENDER>
extends ProfiledMultipleArgumentResolver<SENDER, String, LiteralProfile> {
    public LiteralArgumentResolver() {
        super(ProfileNamespaces.LITERAL);
    }

    @Override
    public ParseResult<String> parse(Invocation<SENDER> invocation, Argument<String> argument, RawInput rawInput, LiteralProfile literalProfile) {
        return this.parse(new ArrayList<String>(), rawInput, literalProfile);
    }

    private ParseResult<String> parse(List<String> before, RawInput rawInput, LiteralProfile literalProfile) {
        String fullLiteral;
        int max = literalProfile.getExpectedRange().getMax();
        if (before.size() >= max) {
            return ParseResult.failure(FailedReason.of((Object)InvalidUsage.Cause.INVALID_ARGUMENT));
        }
        if (!rawInput.hasNext()) {
            return ParseResult.failure(FailedReason.of((Object)InvalidUsage.Cause.MISSING_ARGUMENT));
        }
        String partOfLiteral = rawInput.next();
        String string = fullLiteral = before.isEmpty() ? partOfLiteral : String.join((CharSequence)" ", before) + " " + partOfLiteral;
        if (literalProfile.getLiterals().contains(fullLiteral)) {
            return ParseResult.success(fullLiteral);
        }
        before.add(partOfLiteral);
        return this.parse(before, rawInput, literalProfile);
    }

    @Override
    public Range getRange(Argument<String> argument, LiteralProfile literalProfile) {
        return literalProfile.getExpectedRange();
    }

    @Override
    protected SuggestionResult suggest(Invocation<SENDER> invocation, Argument<String> argument, SuggestionContext context, LiteralProfile literalProfile) {
        return SuggestionResult.of(literalProfile.getLiterals());
    }
}

