/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.input.raw;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.input.ParseableInput;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.suggester.input.SuggestionInput;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.input.raw.RawInput;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.util.StringUtil;
import java.util.Collections;
import java.util.List;

public class RawCommand {
    public static final String COMMAND_SLASH = "/";
    public static final String COMMAND_SEPARATOR = " ";
    public static final char COMMAND_SEPARATOR_CHAR = ' ';
    private final String label;
    private final List<String> args;

    private RawCommand(String label, List<String> args) {
        this.label = label;
        this.args = args;
    }

    public String getLabel() {
        return this.label;
    }

    public RawInput toRawInput() {
        return RawInput.of(this.args);
    }

    public SuggestionInput<?> toSuggestionInput() {
        return SuggestionInput.raw(this.args);
    }

    public ParseableInput<?> toParseableInput() {
        return ParseableInput.raw(this.args);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public static RawCommand from(String rawInput) {
        String rawCommand = rawInput.startsWith(COMMAND_SLASH) ? rawInput.substring(COMMAND_SLASH.length()) : rawInput;
        List<String> rawCommandParts = StringUtil.splitBySpace(rawCommand);
        String commandLabel = rawCommandParts.get(0);
        List<String> commandArgs = rawCommandParts.size() > 1 ? rawCommandParts.subList(1, rawCommandParts.size()) : Collections.emptyList();
        return new RawCommand(commandLabel, commandArgs);
    }
}

