/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.cooldown;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.cooldown.CooldownContext;
import java.time.Duration;
import java.time.Instant;

public class CooldownState {
    private final CooldownContext cooldownContext;
    private final Instant expirationTime;

    public CooldownState(CooldownContext cooldownContext, Instant expirationTime) {
        this.cooldownContext = cooldownContext;
        this.expirationTime = expirationTime;
    }

    public CooldownContext getCooldownContext() {
        return this.cooldownContext;
    }

    public Duration getRemainingDuration() {
        return Duration.between(Instant.now(), this.expirationTime);
    }

    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public boolean isExpired() {
        return Instant.now().isAfter(this.expirationTime);
    }

    public String toString() {
        return "CooldownState{cooldownContext=" + this.cooldownContext.getKey() + ", expirationTime=" + this.expirationTime + '}';
    }
}

