/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.command.executor.event;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.command.executor.CommandExecutor;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.command.executor.event.CommandExecutorEvent;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.command.executor.flow.ExecuteFlow;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.command.executor.flow.ExecuteFlowEvent;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.event.Event;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.FailedReason;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.Preconditions;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
abstract class AbstractCommandExecutorEvent<SENDER>
implements Event,
CommandExecutorEvent<SENDER>,
ExecuteFlowEvent<FailedReason> {
    private final Invocation<SENDER> invocation;
    private final CommandExecutor<SENDER> executor;
    private ExecuteFlow flow = ExecuteFlow.CONTINUE;
    private FailedReason cancelReason;

    protected AbstractCommandExecutorEvent(Invocation<SENDER> invocation, CommandExecutor<SENDER> executor) {
        this.invocation = invocation;
        this.executor = executor;
    }

    @Override
    public Invocation<SENDER> getInvocation() {
        return this.invocation;
    }

    @Override
    public CommandExecutor<SENDER> getExecutor() {
        return this.executor;
    }

    @Override
    public ExecuteFlow getFlow() {
        return this.flow;
    }

    @Override
    @Nullable
    public FailedReason getFlowResult() {
        if (this.flow == ExecuteFlow.CONTINUE) {
            throw new IllegalStateException("Cannot get cancel reason when flow is not TERMINATE or SKIP");
        }
        return this.cancelReason;
    }

    @Override
    public void continueFlow() {
        this.flow = ExecuteFlow.CONTINUE;
        this.cancelReason = null;
    }

    @Override
    public void stopFlow(FailedReason reason) {
        Preconditions.notNull(reason, "reason");
        this.flow = ExecuteFlow.STOP;
        this.cancelReason = reason;
    }

    @Override
    public void skipFlow(FailedReason reason) {
        Preconditions.notNull(reason, "reason");
        this.flow = ExecuteFlow.SKIP;
        this.cancelReason = reason;
    }
}

