/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bukkit.argument;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.LiteCommandsException;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bukkit.LiteBukkitMessages;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.message.MessageRegistry;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.lang.reflect.InvocationTargetException;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class WorldArgument
extends ArgumentResolver<CommandSender, World> {
    private final Server server;
    private final MessageRegistry<CommandSender> messageRegistry;

    public WorldArgument(Server server, MessageRegistry<CommandSender> messageRegistry) {
        this.server = server;
        this.messageRegistry = messageRegistry;
    }

    @Override
    protected ParseResult<World> parse(Invocation<CommandSender> invocation, Argument<World> context, String argument) {
        World world = this.server.getWorld(argument);
        if (world == null) {
            return ParseResult.failure(this.messageRegistry.getInvoked(LiteBukkitMessages.WORLD_NOT_EXIST, invocation, argument));
        }
        return ParseResult.success(world);
    }

    @Override
    public SuggestionResult suggest(Invocation<CommandSender> invocation, Argument<World> argument, SuggestionContext context) {
        return this.server.getWorlds().stream().map(world -> this.getWorldName((World)world)).collect(SuggestionResult.collector());
    }

    private String getWorldName(World world) {
        Class<?> worldClass = world.getClass();
        try {
            return (String)worldClass.getMethod("getName", new Class[0]).invoke((Object)world, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            throw new LiteCommandsException(exception);
        }
    }
}

