/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bukkit;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bukkit.BukkitCommand;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bukkit.TabCompleteSync;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.input.raw.RawCommand;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.reflect.LiteCommandsReflectException;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.reflect.ReflectUtil;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.scheduler.Scheduler;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.scheduler.SchedulerPoll;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.Suggestion;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.libs.jline.console.ConsoleReader;
import org.bukkit.craftbukkit.libs.jline.console.completer.Completer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class TabCompleteProtocolLibAsync
extends TabCompleteSync {
    private static final ProtocolManager MANAGER = ProtocolLibrary.getProtocolManager();
    private final Scheduler scheduler;
    private PacketAdapter listener;

    TabCompleteProtocolLibAsync(Plugin plugin, Scheduler scheduler) {
        this.scheduler = scheduler;
        this.tryReplaceConsoleTabCompleter(plugin.getServer());
        this.listener = new PacketAdapter(plugin, new PacketType[]{PacketType.Play.Client.TAB_COMPLETE}){

            public void onPacketReceiving(PacketEvent event) {
                TabCompleteProtocolLibAsync.this.handlePacket(event);
            }
        };
        MANAGER.addPacketListener((PacketListener)this.listener);
    }

    private void tryReplaceConsoleTabCompleter(Server server) {
        Object craftServer = ReflectUtil.getFromMethod(server, "getHandle", new Object[0]);
        Object minecraftServer = this.getMinecraftServer(craftServer);
        ConsoleReader reader = (ConsoleReader)ReflectUtil.getFromField(minecraftServer, "reader");
        Collection completers = reader.getCompleters();
        if (completers.size() == 1) {
            Completer completer = (Completer)completers.iterator().next();
            reader.removeCompleter(completer);
            reader.addCompleter((Completer)new ProtocolLibConsoleTabConsoleCompleter((CommandSender)server.getConsoleSender(), completer));
        }
    }

    private Object getMinecraftServer(Object craftServer) {
        try {
            return ReflectUtil.getFromField(craftServer, "server");
        }
        catch (LiteCommandsReflectException exception) {
            return ReflectUtil.getFromField(craftServer, "cserver");
        }
    }

    private void handlePacket(PacketEvent event) {
        Player player = event.getPlayer();
        String buffer = (String)event.getPacket().getStrings().read(0);
        if (!buffer.startsWith("/")) {
            return;
        }
        RawCommand rawCommand = RawCommand.from(buffer);
        String commandName = rawCommand.getLabel();
        BukkitCommand command = (BukkitCommand)((Object)this.listeners.get(commandName));
        if (command == null) {
            return;
        }
        event.setCancelled(true);
        this.scheduler.run(SchedulerPoll.SUGGESTER, () -> {
            try {
                Set<Suggestion> suggestions = command.suggest((CommandSender)player, commandName, rawCommand.getArgs().toArray(new String[0])).get(15L, TimeUnit.SECONDS);
                if (suggestions == null) {
                    return;
                }
                String[] list = (String[])suggestions.stream().map(c -> c.multilevel()).toArray(String[]::new);
                PacketContainer packet = MANAGER.createPacket(PacketType.Play.Server.TAB_COMPLETE);
                packet.getStringArrays().write(0, (Object)list);
                MANAGER.sendServerPacket(player, packet);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void close() {
        super.close();
        if (this.listener != null) {
            ProtocolLibrary.getProtocolManager().removePacketListener((PacketListener)this.listener);
            this.listener = null;
        }
    }

    private class ProtocolLibConsoleTabConsoleCompleter
    implements Completer {
        private final Completer completer;
        private final CommandSender consoleSender;

        public ProtocolLibConsoleTabConsoleCompleter(CommandSender consoleSender, Completer completer) {
            this.completer = completer;
            this.consoleSender = consoleSender;
        }

        public int complete(String buffer, int cursor, List<CharSequence> candidates) {
            int lastSpace;
            int completed = this.completer.complete(buffer, cursor, candidates);
            Set<Suggestion> result = TabCompleteProtocolLibAsync.this.callListener(this.consoleSender, buffer);
            if (result == null && cursor == completed) {
                return completed;
            }
            if (result != null) {
                for (Suggestion suggestion : result) {
                    candidates.add(suggestion.multilevel());
                }
            }
            if ((lastSpace = buffer.lastIndexOf(32)) == -1) {
                return cursor - buffer.length();
            }
            return cursor - (buffer.length() - lastSpace - 1);
        }
    }
}

