/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bukkit;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.scheduler.AbstractMainThreadBasedScheduler;
import java.time.Duration;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

class BukkitSchedulerImpl
extends AbstractMainThreadBasedScheduler {
    private final BukkitScheduler bukkitScheduler;
    private final Plugin plugin;

    BukkitSchedulerImpl(BukkitScheduler bukkitScheduler, Plugin plugin) {
        this.bukkitScheduler = bukkitScheduler;
        this.plugin = plugin;
    }

    @Override
    public void shutdown() {
    }

    @Override
    protected void runSynchronous(Runnable task, Duration delay) {
        if (Bukkit.isPrimaryThread() && delay.isZero()) {
            task.run();
            return;
        }
        if (delay.isZero()) {
            this.bukkitScheduler.runTask(this.plugin, task);
        } else {
            this.bukkitScheduler.runTaskLater(this.plugin, task, this.toTicks(delay));
        }
    }

    @Override
    protected void runAsynchronous(Runnable task, Duration delay) {
        if (delay.isZero()) {
            this.bukkitScheduler.runTaskAsynchronously(this.plugin, task);
        } else {
            this.bukkitScheduler.runTaskLaterAsynchronously(this.plugin, task, this.toTicks(delay));
        }
    }

    @Override
    protected void log(Throwable throwable) {
        this.plugin.getLogger().log(Level.SEVERE, "An error occurred while executing a task", throwable);
    }

    private long toTicks(Duration duration) {
        return duration.toMillis() / 50L;
    }
}

