/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.resolver.standard;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.resolver.MultipleArgumentResolver;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.input.raw.RawInput;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.message.MessageKey;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.message.MessageRegistry;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.range.Range;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.Suggestion;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.util.StringUtil;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;

class TemporalAccessorArgumentResolver<SENDER, UNIT extends TemporalAccessor>
implements MultipleArgumentResolver<SENDER, UNIT> {
    private static final String ARGUMENT_SEPARATOR = " ";
    private static final String FORMATTER_ELEMENT_SEPARATOR = " ";
    private final MessageRegistry<SENDER> messageRegistry;
    private final MessageKey<String> invalidFormatMessage;
    private final DateTimeFormatter formatter;
    private final TemporalQuery<UNIT> query;
    private final Supplier<List<UNIT>> suggestions;
    private final int argumentCount;
    private final Pattern pattern;

    protected TemporalAccessorArgumentResolver(MessageRegistry<SENDER> messageRegistry, MessageKey<String> invalidFormatMessage, DateTimeFormatter formatter, TemporalQuery<UNIT> query, Supplier<List<UNIT>> suggestions, Pattern pattern) {
        this.messageRegistry = messageRegistry;
        this.invalidFormatMessage = invalidFormatMessage;
        this.formatter = formatter;
        this.query = query;
        this.suggestions = suggestions;
        this.argumentCount = this.getElementCount(formatter);
        this.pattern = pattern;
    }

    protected TemporalAccessorArgumentResolver(MessageRegistry<SENDER> messageRegistry, MessageKey<String> invalidFormatMessage, String formatterPattern, TemporalQuery<UNIT> query, Supplier<List<UNIT>> suggestions, Pattern pattern) {
        this(messageRegistry, invalidFormatMessage, DateTimeFormatter.ofPattern(formatterPattern), query, suggestions, pattern);
    }

    @Override
    public ParseResult<UNIT> parse(Invocation<SENDER> invocation, Argument<UNIT> argument, RawInput rawInput) {
        String commandInput = String.join((CharSequence)" ", rawInput.seeNext(this.argumentCount));
        try {
            String rawInstant = String.join((CharSequence)" ", rawInput.next(this.argumentCount));
            return ParseResult.success(this.formatter.parse((CharSequence)rawInstant, this.query));
        }
        catch (DateTimeException exception) {
            return ParseResult.failure(this.messageRegistry.getInvoked(this.invalidFormatMessage, invocation, commandInput));
        }
    }

    @Override
    public boolean match(Invocation<SENDER> invocation, Argument<UNIT> argument, RawInput input) {
        return this.pattern.matcher(String.join((CharSequence)" ", input.seeAll())).find();
    }

    @Override
    public SuggestionResult suggest(Invocation<SENDER> invocation, Argument<UNIT> argument, SuggestionContext context) {
        Suggestion suggestion = context.getCurrent();
        int lengthMultilevel = suggestion.lengthMultilevel();
        suggestion = suggestion.deleteRight(Math.max(lengthMultilevel - 2, 0));
        String left = suggestion.multilevel();
        return this.suggestions.get().stream().map(temporal -> {
            String formatted = this.formatter.format((TemporalAccessor)temporal);
            if (formatted.length() <= left.length()) {
                return left;
            }
            return left + formatted.substring(left.length());
        }).filter(text -> this.pattern.matcher((CharSequence)text).find()).collect(SuggestionResult.collector());
    }

    @Override
    public Range getRange(Argument<UNIT> unitArgument) {
        return Range.of(this.argumentCount);
    }

    private int getElementCount(DateTimeFormatter formatter) {
        return StringUtil.splitBySpace(formatter.toString()).size();
    }
}

