/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.resolver.standard;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.resolver.standard.TemporalAccessorArgumentResolver;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.resolver.standard.TemporalAccessorUtils;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.message.LiteMessages;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.message.MessageRegistry;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.regex.Pattern;

public class LocalDateTimeArgumentResolver<SENDER>
extends TemporalAccessorArgumentResolver<SENDER, LocalDateTime> {
    private static final Pattern PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}");
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());

    public LocalDateTimeArgumentResolver(MessageRegistry<SENDER> messageRegistry) {
        super(messageRegistry, LiteMessages.INSTANT_INVALID_FORMAT, FORMATTER, (TemporalAccessor temporal) -> LocalDateTime.from(temporal), () -> TemporalAccessorUtils.allDaysOfWeek(LocalDateTime.now()), PATTERN);
    }
}

