/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.resolver.standard;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.resolver.ArgumentResolver;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.message.LiteMessages;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.message.MessageRegistry;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionContext;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.suggestion.SuggestionResult;
import java.math.BigInteger;
import java.util.stream.Stream;

public class BigIntegerArgumentResolver<SENDER>
extends ArgumentResolver<SENDER, BigInteger> {
    private static final SuggestionResult SUGGESTIONS = Stream.of("0", "1", "5", "10", "25", "50", "100", "250", "500").collect(SuggestionResult.collector());
    private final MessageRegistry<SENDER> messageRegistry;

    public BigIntegerArgumentResolver(MessageRegistry<SENDER> messageRegistry) {
        this.messageRegistry = messageRegistry;
    }

    @Override
    protected ParseResult<BigInteger> parse(Invocation<SENDER> invocation, Argument<BigInteger> context, String argument) {
        try {
            return ParseResult.success(new BigInteger(argument));
        }
        catch (NumberFormatException ignored) {
            return ParseResult.failure(this.messageRegistry.getInvoked(LiteMessages.INVALID_NUMBER, invocation, argument));
        }
    }

    @Override
    public SuggestionResult suggest(Invocation<SENDER> invocation, Argument<BigInteger> argument, SuggestionContext context) {
        return SUGGESTIONS;
    }
}

