/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.input;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.Parser;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.input.ParseableInput;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.input.ParseableInputMatcher;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.input.raw.RawInput;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invalidusage.InvalidUsage;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.invocation.Invocation;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.priority.PriorityLevel;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.reflect.ReflectUtil;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.FailedReason;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

class NamedTypedParseableInput
implements ParseableInput<TypeMixedInputMatcher> {
    private final List<String> routes = new ArrayList<String>();
    private final Map<String, Object> namedArguments = new LinkedHashMap<String, Object>();

    NamedTypedParseableInput(List<String> routes, Map<String, Object> namedArguments) {
        this.routes.addAll(routes);
        this.namedArguments.putAll(namedArguments);
    }

    @Override
    public TypeMixedInputMatcher createMatcher() {
        return new TypeMixedInputMatcher();
    }

    @Override
    public List<String> asList() {
        ArrayList rawArgs = new ArrayList();
        this.namedArguments.forEach((named, object) -> {
            rawArgs.add(named);
            rawArgs.add(object.toString());
        });
        return Collections.unmodifiableList(rawArgs);
    }

    class TypeMixedInputMatcher
    implements ParseableInputMatcher<TypeMixedInputMatcher> {
        private int routePosition = 0;
        private final Set<String> consumedArguments = new HashSet<String>();

        public TypeMixedInputMatcher() {
        }

        public TypeMixedInputMatcher(int routePosition) {
            this.routePosition = routePosition;
        }

        @Override
        public <SENDER, T> ParseResult<T> nextArgument(Invocation<SENDER> invocation, Argument<T> argument, Supplier<Parser<SENDER, T>> parserProvider) {
            Object input = NamedTypedParseableInput.this.namedArguments.get(argument.getName());
            if (input == null) {
                return ParseResult.failure((Object)InvalidUsage.Cause.MISSING_ARGUMENT);
            }
            Class type = argument.getType().getRawType();
            this.consumedArguments.add(argument.getName());
            if (ReflectUtil.instanceOf(input, type)) {
                return ParseResult.success(input);
            }
            Parser<SENDER, T> parser = parserProvider.get();
            return parser.parse(invocation, argument, RawInput.of(input.toString().split(" ")));
        }

        @Override
        public boolean hasNextRoute() {
            return this.routePosition < NamedTypedParseableInput.this.routes.size();
        }

        @Override
        public String showNextRoute() {
            return (String)NamedTypedParseableInput.this.routes.get(this.routePosition);
        }

        @Override
        public String nextRoute() {
            return (String)NamedTypedParseableInput.this.routes.get(this.routePosition++);
        }

        @Override
        public TypeMixedInputMatcher copy() {
            return new TypeMixedInputMatcher(this.routePosition);
        }

        @Override
        public ParseableInputMatcher.EndResult endMatch(boolean isStrict) {
            if (this.consumedArguments.size() < NamedTypedParseableInput.this.namedArguments.size() && isStrict) {
                return ParseableInputMatcher.EndResult.failed(FailedReason.of((Object)InvalidUsage.Cause.TOO_MANY_ARGUMENTS, PriorityLevel.LOW));
            }
            return ParseableInputMatcher.EndResult.success();
        }
    }
}

