/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.ArgumentKey;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.EmptyParserSetImpl;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.NamespacedParserSet;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.Parser;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParserSet;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParserSetImpl;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.BiHashMap;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.shared.BiMap;
import org.jetbrains.annotations.Nullable;

class ParserNamespacedIndex<SENDER, PARSED> {
    private final BiMap<String, String, ParserSetImpl<SENDER, PARSED>> unNamespacedIndex = new BiHashMap<String, String, ParserSetImpl<SENDER, PARSED>>();
    private final BiMap<String, String, ParserSetImpl<SENDER, PARSED>> namespacedIndex = new BiHashMap<String, String, ParserSetImpl<SENDER, PARSED>>();

    ParserNamespacedIndex() {
    }

    void registerParser(ArgumentKey key, Parser<SENDER, PARSED> parser) {
        if (key.isDefaultNamespace()) {
            ParserSetImpl bucket = this.unNamespacedIndex.computeIfAbsent(key.getKey(), key.getNamespace(), (k1, k2) -> new ParserSetImpl());
            bucket.registerParser(parser);
            return;
        }
        ParserSetImpl bucket = this.namespacedIndex.computeIfAbsent(key.getKey(), key.getNamespace(), (k1, k2) -> new NamespacedParserSet(key.getNamespace()));
        bucket.registerParser(parser);
    }

    @Nullable
    ParserSet<SENDER, PARSED> getParserSet(ArgumentKey key) {
        ParserSet parserSet = this.namespacedIndex.get(key.getKey(), key.getNamespace());
        if (parserSet != null) {
            return parserSet;
        }
        parserSet = this.namespacedIndex.get("", key.getNamespace());
        if (parserSet != null) {
            return parserSet;
        }
        parserSet = this.unNamespacedIndex.get(key.getKey(), ArgumentKey.DEFAULT_NAMESPACE);
        if (parserSet != null) {
            return parserSet;
        }
        parserSet = this.unNamespacedIndex.get("", ArgumentKey.DEFAULT_NAMESPACE);
        if (parserSet != null) {
            return parserSet;
        }
        return new EmptyParserSetImpl();
    }
}

