/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.ArgumentKey;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.MutableArgument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.parser.ParseResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.profile.ArgumentProfile;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.profile.ArgumentProfileNamespace;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.meta.Meta;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.meta.MetaHolder;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.priority.MutablePrioritizedList;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.priority.PrioritizedList;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.reflect.type.TypeToken;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SimpleArgument<T>
implements MutableArgument<T> {
    private final String name;
    private final TypeToken<T> type;
    private final Meta meta = Meta.create();
    private ArgumentKey key;
    private volatile int hashCode;
    @Nullable
    private Argument<?> pattern;
    private final MutablePrioritizedList<ArgumentProfile<?>> profiles = new MutablePrioritizedList();
    @Deprecated
    private final boolean nullable;

    protected SimpleArgument(String name, TypeToken<T> type, @Nullable Argument<?> pattern) {
        this(name, type);
        this.pattern = pattern;
    }

    public SimpleArgument(String name, TypeToken<T> type) {
        this(name, type, false);
    }

    public SimpleArgument(String name, TypeToken<T> type, @Deprecated boolean nullable) {
        this.name = name;
        this.type = type;
        this.nullable = nullable;
        this.setKey(ArgumentKey.of(this.getClass().getName(), name));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ArgumentKey getKey() {
        return this.key;
    }

    @Override
    public void setKey(ArgumentKey key) {
        this.key = key;
        this.hashCode = this.createHashCode();
    }

    @Override
    public TypeToken<T> getType() {
        return this.type;
    }

    @Override
    public Meta meta() {
        return this.meta;
    }

    @Override
    @Nullable
    public MetaHolder parentMeta() {
        return this.pattern;
    }

    @Override
    public Optional<ParseResult<T>> getDefaultValue() {
        if (this.nullable) {
            return Optional.of(ParseResult.successNull());
        }
        return Optional.empty();
    }

    @Override
    public boolean hasDefaultValue() {
        return this.nullable || this.getDefaultValue().isPresent();
    }

    @Override
    @ApiStatus.Experimental
    public <P extends ArgumentProfile<P>> SimpleArgument<T> addProfile(P profile) {
        ArgumentProfileNamespace<P> namespace = profile.getNamespace();
        this.profiles.add(profile);
        this.meta.put(namespace.asMetaKey(), profile);
        if (this.profiles.first().equals(profile)) {
            this.setKey(this.key.withNamespace(namespace.getNamespace()));
        }
        return this;
    }

    @Override
    @ApiStatus.Experimental
    public <P> Optional<P> getProfile(ArgumentProfileNamespace<P> key) {
        return Optional.ofNullable(this.meta.get(key.asMetaKey(), null));
    }

    @Override
    public PrioritizedList<ArgumentProfile<?>> getProfiles() {
        return this.profiles;
    }

    @Override
    public <NEW> Argument<NEW> child(TypeToken<NEW> type) {
        SimpleArgument<NEW> newSimpleArgument = new SimpleArgument<NEW>(this.name, type, this);
        newSimpleArgument.setKey(this.key.withDefaultNamespace());
        newSimpleArgument.meta.putAll(this.meta);
        for (ArgumentProfile<?> argumentProfile : this.profiles) {
            newSimpleArgument.addProfile(argumentProfile);
        }
        return newSimpleArgument;
    }

    @Override
    public Argument<T> withoutProfile(ArgumentProfileNamespace<?> profile) {
        SimpleArgument<T> argument = new SimpleArgument<T>(this.name, this.type, this.nullable);
        argument.setKey(this.key.withDefaultNamespace());
        argument.meta.putAll(this.meta);
        for (ArgumentProfile<?> argumentProfile : this.profiles) {
            if (!argumentProfile.getNamespace().equals(profile)) {
                argument.addProfile(argumentProfile);
                continue;
            }
            argument.meta.remove(profile.asMetaKey());
        }
        return argument;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleArgument that = (SimpleArgument)o;
        return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int createHashCode() {
        return Objects.hash(this.getKey(), this.type);
    }
}

