/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.inject;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.LiteCommandsException;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations.inject.Inject;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bind.BindRegistry;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bind.BindResult;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.reflect.LiteCommandsReflectInvocationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Injector {
    private final BindRegistry registry;

    public Injector(BindRegistry registry) {
        this.registry = registry;
    }

    public <T> T createInstance(Class<T> type) {
        List constructors = Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> constructor.isAnnotationPresent(Inject.class) || constructor.getParameterCount() == 0).sorted((o1, o2) -> Integer.compare(o2.getParameterCount(), o1.getParameterCount())).collect(Collectors.toList());
        if (constructors.isEmpty()) {
            throw new LiteCommandsReflectInvocationException(type, "Missing constructor with @Inject annotation or without parameters");
        }
        ArrayList<LiteCommandsReflectInvocationException> exceptions = new ArrayList<LiteCommandsReflectInvocationException>();
        for (Constructor constructor2 : constructors) {
            Object[] parameters = new Object[constructor2.getParameterCount()];
            for (int i = 0; i < constructor2.getParameterCount(); ++i) {
                Parameter parameter = constructor2.getParameters()[i];
                Class<?> parameterType = parameter.getType();
                BindResult<?> result = this.registry.getInstance(parameterType);
                if (result.isError()) {
                    exceptions.add(new LiteCommandsReflectInvocationException((Executable)constructor2, parameter, "Cannot inject parameter " + parameterType.getName() + " error: " + result.getError()));
                    continue;
                }
                parameters[i] = result.getSuccess();
            }
            try {
                constructor2.setAccessible(true);
                return constructor2.newInstance(parameters);
            }
            catch (Exception exception) {
                exceptions.add(new LiteCommandsReflectInvocationException((Executable)constructor2, "Cannot create invoke construcotr", exception));
            }
        }
        throw new LiteCommandsException("Cannot create instance of " + type.getName(), exceptions);
    }
}

