/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.annotations;

import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.argument.Argument;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.bind.BindRequirement;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.context.ContextRequirement;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.reflect.LiteCommandsReflectInvocationException;
import com.github.imdmk.spenttime.plugin.lib.dev.rollczi.litecommands.requirement.Requirement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodDefinition {
    private final Method method;
    private final Map<Integer, Argument<?>> arguments = new HashMap();
    private final Map<Integer, ContextRequirement<?>> contextRequirements = new HashMap();
    private final Map<Integer, BindRequirement<?>> bindRequirements = new HashMap();
    private List<Requirement<?>> indexedRequirements;

    MethodDefinition(Method method) {
        this.method = method;
    }

    public Requirement<?> getRequirement(int parameterIndex) {
        return this.getRequirements().get(parameterIndex);
    }

    public List<Requirement<?>> getRequirements() {
        if (this.indexedRequirements == null) {
            ArrayList indexedRequirements = new ArrayList();
            for (int i = 0; i < this.method.getParameterCount(); ++i) {
                indexedRequirements.add(this.getRequirement0(i));
            }
            this.indexedRequirements = indexedRequirements;
            return indexedRequirements;
        }
        return this.indexedRequirements;
    }

    private Requirement<?> getRequirement0(int parameterIndex) {
        Argument<?> argument = this.arguments.get(parameterIndex);
        if (argument != null) {
            return argument;
        }
        ContextRequirement<?> contextRequirement = this.contextRequirements.get(parameterIndex);
        if (contextRequirement != null) {
            return contextRequirement;
        }
        BindRequirement<?> bindRequirement = this.bindRequirements.get(parameterIndex);
        if (bindRequirement != null) {
            return bindRequirement;
        }
        throw new IllegalArgumentException("Cannot find requirement for parameter index " + parameterIndex);
    }

    boolean hasRequirement(int parameterIndex) {
        return this.arguments.containsKey(parameterIndex) || this.contextRequirements.containsKey(parameterIndex) || this.bindRequirements.containsKey(parameterIndex);
    }

    public Collection<Argument<?>> getArguments() {
        return this.arguments.values();
    }

    public Collection<ContextRequirement<?>> getContextRequirements() {
        return this.contextRequirements.values();
    }

    public Collection<BindRequirement<?>> getBindRequirements() {
        return this.bindRequirements.values();
    }

    void putRequirement(int parameterIndex, Requirement<?> requirement) {
        Parameter parameter;
        Class<?> rawType = requirement.getType().getRawType();
        if (!rawType.isAssignableFrom((parameter = this.method.getParameters()[parameterIndex]).getType())) {
            throw new LiteCommandsReflectInvocationException((Executable)this.method, parameter, "Parameter type is not assignable from " + rawType.getSimpleName());
        }
        if (requirement instanceof Argument) {
            if (this.arguments.containsKey(parameterIndex)) {
                throw new LiteCommandsReflectInvocationException((Executable)this.method, parameter, "Cannot put argument on index " + parameterIndex + " because it is already occupied!");
            }
            this.arguments.put(parameterIndex, (Argument)requirement);
            return;
        }
        if (requirement instanceof ContextRequirement) {
            if (this.contextRequirements.containsKey(parameterIndex)) {
                throw new LiteCommandsReflectInvocationException((Executable)this.method, parameter, "Cannot put context requirement on index " + parameterIndex + " because it is already occupied!");
            }
            this.contextRequirements.put(parameterIndex, (ContextRequirement)requirement);
            return;
        }
        if (requirement instanceof BindRequirement) {
            if (this.bindRequirements.containsKey(parameterIndex)) {
                throw new LiteCommandsReflectInvocationException((Executable)this.method, parameter, "Cannot put bind requirement on index " + parameterIndex + " because it is already occupied!");
            }
            this.bindRequirements.put(parameterIndex, (BindRequirement)requirement);
            return;
        }
        throw new LiteCommandsReflectInvocationException((Executable)this.method, parameter, "Cannot put requirement on index " + parameterIndex + " because it is not supported!");
    }
}

