/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.support;

import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.logger.Logger;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.support.ConnectionSource;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.support.DatabaseConnection;
import java.sql.SQLException;

public abstract class BaseConnectionSource
implements ConnectionSource {
    private ThreadLocal<NestedConnection> specialConnection = new ThreadLocal();

    @Override
    public DatabaseConnection getSpecialConnection(String tableName) {
        NestedConnection currentSaved = this.specialConnection.get();
        if (currentSaved == null) {
            return null;
        }
        return currentSaved.connection;
    }

    protected DatabaseConnection getSavedConnection() {
        NestedConnection nested = this.specialConnection.get();
        if (nested == null) {
            return null;
        }
        return nested.connection;
    }

    protected boolean isSavedConnection(DatabaseConnection connection) {
        NestedConnection currentSaved = this.specialConnection.get();
        if (currentSaved == null) {
            return false;
        }
        return currentSaved.connection == connection;
    }

    protected boolean saveSpecial(DatabaseConnection connection) throws SQLException {
        NestedConnection currentSaved = this.specialConnection.get();
        if (currentSaved == null) {
            this.specialConnection.set(new NestedConnection(connection));
            return true;
        }
        if (currentSaved.connection != connection) {
            throw new SQLException("trying to save connection " + connection + " but already have saved connection " + currentSaved.connection);
        }
        currentSaved.increment();
        return false;
    }

    protected boolean clearSpecial(DatabaseConnection connection, Logger logger) {
        NestedConnection currentSaved = this.specialConnection.get();
        boolean cleared = false;
        if (connection != null) {
            if (currentSaved == null) {
                logger.error("no connection has been saved when clear() called");
            } else if (currentSaved.connection == connection) {
                if (currentSaved.decrementAndGet() == 0) {
                    this.specialConnection.set(null);
                }
                cleared = true;
            } else {
                logger.error("connection saved {} is not the one being cleared {}", currentSaved.connection, (Object)connection);
            }
        }
        return cleared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isSingleConnection(DatabaseConnection conn1, DatabaseConnection conn2) throws SQLException {
        conn1.setAutoCommit(true);
        conn2.setAutoCommit(true);
        try {
            conn1.setAutoCommit(false);
            if (conn2.isAutoCommit()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            conn1.setAutoCommit(true);
        }
    }

    private static class NestedConnection {
        public final DatabaseConnection connection;
        private int nestedC;

        public NestedConnection(DatabaseConnection connection) {
            this.connection = connection;
            this.nestedC = 1;
        }

        public void increment() {
            ++this.nestedC;
        }

        public int decrementAndGet() {
            --this.nestedC;
            return this.nestedC;
        }
    }
}

