/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.misc;

import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.dao.Dao;
import java.sql.SQLException;

public abstract class BaseDaoEnabled<T, ID> {
    protected transient Dao<T, ID> dao;

    public int create() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t2 = this;
        return this.dao.create(t2);
    }

    public int refresh() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t2 = this;
        return this.dao.refresh(t2);
    }

    public int update() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t2 = this;
        return this.dao.update(t2);
    }

    public int updateId(ID newId) throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t2 = this;
        return this.dao.updateId(t2, newId);
    }

    public int delete() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t2 = this;
        return this.dao.delete(t2);
    }

    public String objectToString() {
        try {
            this.checkForDao();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException(e);
        }
        BaseDaoEnabled t2 = this;
        return this.dao.objectToString(t2);
    }

    public ID extractId() throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t2 = this;
        return this.dao.extractId(t2);
    }

    public boolean objectsEqual(T other) throws SQLException {
        this.checkForDao();
        BaseDaoEnabled t2 = this;
        return this.dao.objectsEqual(t2, (BaseDaoEnabled)other);
    }

    public void setDao(Dao<T, ID> dao) {
        this.dao = dao;
    }

    public Dao<T, ID> getDao() {
        return this.dao;
    }

    private void checkForDao() throws SQLException {
        if (this.dao == null) {
            throw new SQLException("Dao has not been set on " + this.getClass() + " object: " + this);
        }
    }
}

