/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.jdbc.db;

import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.db.BaseDatabaseType;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.BaseFieldConverter;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.DataPersister;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.FieldConverter;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.FieldType;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.SqlType;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.converter.BooleanNumberFieldConverter;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.converter.CharacterCompatFieldConverter;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.support.DatabaseResults;
import java.sql.SQLException;
import java.util.List;

public class SqlServerDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "sqlserver";
    private static final String DRIVER_CLASS_NAME = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
    private static final String DATABASE_NAME = "SQL Server";
    private static final FieldConverter byteConverter = new ByteFieldConverter();
    private static final FieldConverter booleanConverter = new BooleanNumberFieldConverter();

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME};
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    public FieldConverter getFieldConverter(DataPersister dataType, FieldType fieldType) {
        switch (dataType.getSqlType()) {
            case BOOLEAN: {
                return booleanConverter;
            }
            case BYTE: {
                return byteConverter;
            }
            case CHAR: {
                return new CharacterCompatFieldConverter(dataType);
            }
        }
        return super.getFieldConverter(dataType, fieldType);
    }

    @Override
    protected void appendUuidNativeType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("UNIQUEIDENTIFIER");
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BIT");
    }

    @Override
    protected void appendByteType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("SMALLINT");
    }

    @Override
    protected void appendDateType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("DATETIME");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("IMAGE");
    }

    @Override
    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("IMAGE");
    }

    @Override
    protected void configureGeneratedId(String tableName, StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter, List<String> additionalArgs, List<String> queriesAfter) {
        sb.append("IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
        if (fieldType.isAllowGeneratedIdInsert()) {
            StringBuilder identityInsertSb = new StringBuilder();
            identityInsertSb.append("SET IDENTITY_INSERT ");
            this.appendEscapedEntityName(identityInsertSb, tableName);
            identityInsertSb.append(" ON");
            statementsAfter.add(identityInsertSb.toString());
        }
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        String[] names = name.split("\\.");
        this.appendEscapedEntityNamePart(sb, names[0]);
        for (int i = 1; i < names.length; ++i) {
            sb.append('.');
            this.appendEscapedEntityNamePart(sb, names[i]);
        }
    }

    private void appendEscapedEntityNamePart(StringBuilder sb, String name) {
        sb.append('[').append(name).append(']');
    }

    @Override
    public boolean isLimitAfterSelect() {
        return true;
    }

    @Override
    public boolean isLimitAfterUpdateSupported() {
        return true;
    }

    @Override
    public void appendLimitValue(StringBuilder sb, long limit, Long offset) {
        sb.append("TOP ").append(limit).append(' ');
    }

    @Override
    public void appendUpdateLimitValue(StringBuilder sb, long limit) {
        sb.append("TOP (").append(limit).append(") ");
    }

    @Override
    public boolean isLimitAfterDeleteSupported() {
        return true;
    }

    @Override
    public void appendDeleteLimitValue(StringBuilder sb, long limit) {
        sb.append("TOP (").append(limit).append(") ");
    }

    @Override
    public boolean isOffsetSqlSupported() {
        return false;
    }

    @Override
    public boolean isAllowGeneratedIdInsertSupported() {
        return false;
    }

    @Override
    public boolean isCreateTableReturnsNegative() {
        return true;
    }

    @Override
    public void appendInsertNoColumns(StringBuilder sb) {
        sb.append("DEFAULT VALUES");
    }

    @Override
    public boolean isTruncateSupported() {
        return true;
    }

    private static class ByteFieldConverter
    extends BaseFieldConverter {
        private ByteFieldConverter() {
        }

        @Override
        public SqlType getSqlType() {
            return SqlType.BYTE;
        }

        @Override
        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            return Short.parseShort(defaultStr);
        }

        @Override
        public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
            return results.getShort(columnPos);
        }

        @Override
        public Object sqlArgToJava(FieldType fieldType, Object sqlObject, int columnPos) {
            short shortVal = (Short)sqlObject;
            if (shortVal < -128) {
                return (byte)-128;
            }
            if (shortVal > 127) {
                return (byte)127;
            }
            return (byte)shortVal;
        }

        @Override
        public Object javaToSqlArg(FieldType fieldType, Object javaObject) {
            byte byteVal = (Byte)javaObject;
            return (short)byteVal;
        }

        @Override
        public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) {
            return this.sqlArgToJava(fieldType, Short.parseShort(stringValue), columnPos);
        }
    }
}

