/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.jdbc.db;

import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.db.BaseDatabaseType;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.FieldType;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.SqlType;
import java.util.List;

public class HsqldbDatabaseType
extends BaseDatabaseType {
    private static final String DATABASE_URL_PORTION = "hsqldb";
    private static final String DRIVER_CLASS_NAME = "org.hsqldb.jdbcDriver";
    private static final String DATABASE_NAME = "HSQLdb";

    @Override
    public boolean isDatabaseUrlThisType(String url, String dbTypePart) {
        return DATABASE_URL_PORTION.equals(dbTypePart);
    }

    @Override
    protected String[] getDriverClassNames() {
        return new String[]{DRIVER_CLASS_NAME};
    }

    @Override
    public String getDatabaseName() {
        return DATABASE_NAME;
    }

    @Override
    protected void appendLongStringType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("LONGVARCHAR");
    }

    @Override
    protected void appendBooleanType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        sb.append("BIT");
    }

    @Override
    protected void appendByteArrayType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        if (fieldWidth == 0) {
            sb.append("VARBINARY(255)");
        } else {
            sb.append("VARBINARY(").append(fieldWidth).append(')');
        }
    }

    @Override
    protected void appendSerializableType(StringBuilder sb, FieldType fieldType, int fieldWidth) {
        this.appendByteArrayType(sb, fieldType, fieldWidth);
    }

    @Override
    protected void configureGeneratedIdSequence(StringBuilder sb, FieldType fieldType, List<String> statementsBefore, List<String> additionalArgs, List<String> queriesAfter) {
        StringBuilder seqSb = new StringBuilder(128);
        seqSb.append("CREATE SEQUENCE ");
        this.appendEscapedEntityName(seqSb, fieldType.getGeneratedIdSequence());
        if (fieldType.getSqlType() == SqlType.LONG) {
            seqSb.append(" AS BIGINT");
        }
        seqSb.append(" START WITH 1");
        statementsBefore.add(seqSb.toString());
        sb.append("GENERATED BY DEFAULT AS IDENTITY ");
        this.configureId(sb, fieldType, statementsBefore, additionalArgs, queriesAfter);
    }

    @Override
    public void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('\"').append(name).append('\"');
    }

    @Override
    public void dropColumnArg(FieldType fieldType, List<String> statementsBefore, List<String> statementsAfter) {
        if (fieldType.isGeneratedIdSequence()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("DROP SEQUENCE ");
            this.appendEscapedEntityName(sb, fieldType.getGeneratedIdSequence());
            statementsAfter.add(sb.toString());
        }
    }

    @Override
    public boolean isIdSequenceNeeded() {
        return true;
    }

    @Override
    public boolean isSelectSequenceBeforeInsert() {
        return true;
    }

    @Override
    public boolean isVarcharFieldWidthSupported() {
        return this.driver != null && this.driver.getMajorVersion() >= 2;
    }

    @Override
    public boolean isLimitAfterSelect() {
        return true;
    }

    @Override
    public void appendLimitValue(StringBuilder sb, long limit, Long offset) {
        sb.append("LIMIT ");
        if (offset == null) {
            sb.append("0 ");
        } else {
            sb.append(offset).append(' ');
        }
        sb.append(limit).append(' ');
    }

    @Override
    public boolean isOffsetLimitArgument() {
        return true;
    }

    @Override
    public void appendOffsetValue(StringBuilder sb, long offset) {
        throw new IllegalStateException("Offset is part of the LIMIT in database type " + this.getClass());
    }

    @Override
    public void appendSelectNextValFromSequence(StringBuilder sb, String sequenceName) {
        sb.append("CALL NEXT VALUE FOR ");
        this.appendEscapedEntityName(sb, sequenceName);
    }

    @Override
    public boolean isEntityNamesMustBeUpCase() {
        return true;
    }

    @Override
    public String getPingStatement() {
        return "SELECT COUNT(*) FROM INFORMATION_SCHEMA.SYSTEM_TABLES";
    }

    @Override
    public boolean isCreateIfNotExistsSupported() {
        return this.driver != null && this.driver.getMajorVersion() >= 2 && this.driver.getMinorVersion() >= 3;
    }
}

