/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.types;

import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.FieldType;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.SqlType;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.types.BaseDataType;
import com.github.imdmk.spenttime.plugin.lib.com.j256.ormlite.field.types.DateStringFormatConfig;
import java.lang.reflect.Field;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public abstract class BaseDateType
extends BaseDataType {
    private static final DateStringFormatConfig DEFAULT_DATE_FORMAT_CONFIG = new DateStringFormatConfig("yyyy-MM-dd HH:mm:ss.SSSSSS");
    private static final DateStringFormatConfig NO_MILLIS_DATE_FORMAT_CONFIG = new DateStringFormatConfig("yyyy-MM-dd HH:mm:ss");

    protected BaseDateType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    protected BaseDateType(SqlType sqlType) {
        super(sqlType);
    }

    protected static DateStringFormatConfig convertDateStringConfig(FieldType fieldType, DateStringFormatConfig defaultDateFormatConfig) {
        if (fieldType == null) {
            return defaultDateFormatConfig;
        }
        DateStringFormatConfig configObj = (DateStringFormatConfig)fieldType.getDataTypeConfigObj();
        if (configObj == null) {
            return defaultDateFormatConfig;
        }
        return configObj;
    }

    protected static Date parseDateString(DateStringFormatConfig formatConfig, String dateStr) throws ParseException {
        DateFormat dateFormat = BaseDateType.conditionalFormat(formatConfig, dateStr);
        return dateFormat.parse(dateStr);
    }

    protected static String normalizeDateString(DateStringFormatConfig formatConfig, String dateStr) throws ParseException {
        DateFormat dateFormat = BaseDateType.conditionalFormat(formatConfig, dateStr);
        Date date = dateFormat.parse(dateStr);
        return dateFormat.format(date);
    }

    @Override
    public boolean isValidForVersion() {
        return true;
    }

    @Override
    public Object moveToNextValue(Object currentValue) {
        long newVal = System.currentTimeMillis();
        if (currentValue == null) {
            return new Date(newVal);
        }
        if (newVal == ((Date)currentValue).getTime()) {
            return new Date(newVal + 1L);
        }
        return new Date(newVal);
    }

    @Override
    public boolean isValidForField(Field field) {
        return field.getType() == Date.class;
    }

    protected DateStringFormatConfig getDefaultDateFormatConfig() {
        return DEFAULT_DATE_FORMAT_CONFIG;
    }

    private static DateFormat conditionalFormat(DateStringFormatConfig formatConfig, String dateStr) {
        if (formatConfig == DEFAULT_DATE_FORMAT_CONFIG && dateStr.indexOf(46) < 0) {
            return NO_MILLIS_DATE_FORMAT_CONFIG.getDateFormat();
        }
        return formatConfig.getDateFormat();
    }
}

