/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.title;

import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.NoticeKey;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.NoticeResolver;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.NoticeSerdesResult;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.title.TitleTimes;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.time.DurationParser;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.time.TemporalAmountParser;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.audience.Audience;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.text.Component;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.text.serializer.ComponentSerializer;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.title.Title;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.title.TitlePart;
import java.time.Duration;
import java.util.Optional;

public class TimesResolver
implements NoticeResolver<TitleTimes> {
    private static final TemporalAmountParser<Duration> DURATION_PARSER = DurationParser.TIME_UNITS;
    private static final String TIMES_FORMAT = "%s %s %s";
    private static final String ZERO_TIME = "0s";

    @Override
    public NoticeKey<TitleTimes> noticeKey() {
        return NoticeKey.TITLE_TIMES;
    }

    @Override
    public void send(Audience audience, ComponentSerializer<Component, Component, String> componentSerializer, TitleTimes content) {
        audience.sendTitlePart(TitlePart.TIMES, Title.Times.times(content.fadeIn(), content.stay(), content.fadeOut()));
    }

    @Override
    public NoticeSerdesResult serialize(TitleTimes content) {
        return new NoticeSerdesResult.Single(String.format(TIMES_FORMAT, this.formatDuration(content.fadeIn()), this.formatDuration(content.stay()), this.formatDuration(content.fadeOut())));
    }

    @Override
    public Optional<TitleTimes> deserialize(NoticeSerdesResult result) {
        Optional<String> firstElement = result.firstElement();
        if (firstElement.isEmpty()) {
            return Optional.empty();
        }
        String[] parts = firstElement.get().split(" ");
        if (parts.length != 3) {
            throw new IllegalArgumentException("Invalid times format " + firstElement.get());
        }
        return Optional.of(new TitleTimes(DURATION_PARSER.parse(parts[0]), DURATION_PARSER.parse(parts[1]), DURATION_PARSER.parse(parts[2])));
    }

    private String formatDuration(Duration duration) {
        if (duration.isNegative() || duration.isZero()) {
            return ZERO_TIME;
        }
        return DURATION_PARSER.format(duration);
    }
}

