/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.chat;

import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.NoticeKey;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.NoticeSerdesResult;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.chat.ChatContent;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.text.TextContentResolver;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.audience.Audience;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.text.Component;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.text.serializer.ComponentSerializer;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;

public class ChatResolver
implements TextContentResolver<ChatContent> {
    private final NoticeKey<ChatContent> key = NoticeKey.CHAT;

    @Override
    public NoticeKey<ChatContent> noticeKey() {
        return this.key;
    }

    @Override
    public void send(Audience audience, ComponentSerializer<Component, Component, String> componentSerializer, ChatContent content) {
        for (String message : content.messages()) {
            audience.sendMessage(componentSerializer.deserialize(message));
        }
    }

    @Override
    public ChatContent applyText(ChatContent content, UnaryOperator<String> function) {
        return new ChatContent(content.messages().stream().map(function).toList());
    }

    @Override
    public NoticeSerdesResult serialize(ChatContent content) {
        List<String> messages = content.messages();
        if (messages.isEmpty()) {
            return new NoticeSerdesResult.Empty();
        }
        if (messages.size() == 1) {
            return new NoticeSerdesResult.Single(messages.get(0));
        }
        return new NoticeSerdesResult.Multiple(messages);
    }

    @Override
    public Optional<ChatContent> deserialize(NoticeSerdesResult result) {
        List<String> messages = result.anyElements();
        if (messages.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new ChatContent(messages));
    }

    @Override
    public ChatContent createFromText(List<String> contents) {
        return new ChatContent(contents);
    }
}

