/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.bukkit.notice.resolver.sound;

import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.bukkit.notice.BukkitNoticeKey;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.bukkit.notice.resolver.sound.SoundBukkit;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.NoticeKey;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.NoticeResolver;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.multification.notice.resolver.NoticeSerdesResult;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.audience.Audience;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.key.Key;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.sound.Sound;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.text.Component;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.text.serializer.ComponentSerializer;
import java.util.Optional;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;

public class SoundBukkitResolver
implements NoticeResolver<SoundBukkit> {
    private static final String MUSIC = "%s";
    private static final String MUSIC_WITH_PITCH_VOLUME = "%s %s %s";
    private static final String MUSIC_FULL = "%s %s %s %s";

    @Override
    public NoticeKey<SoundBukkit> noticeKey() {
        return BukkitNoticeKey.SOUND;
    }

    @Override
    public void send(Audience audience, ComponentSerializer<Component, Component, String> componentSerializer, SoundBukkit content) {
        String soundKey = content.sound().getKey().getKey();
        com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.sound.Sound sound = com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.sound.Sound.sound(Key.key(soundKey), Sound.Source.valueOf(content.toKyoriCategory().name()), content.volumeOrDefault(), content.pitchOrDefault());
        audience.playSound(sound);
    }

    @Override
    public NoticeSerdesResult serialize(SoundBukkit content) {
        if (content.category() == null) {
            if (content.pitch() == SoundBukkit.PITCH_UNSET.floatValue() || content.volume() == SoundBukkit.VOLUME_UNSET.floatValue()) {
                return new NoticeSerdesResult.Single(String.format(MUSIC, content.sound().name()));
            }
            return new NoticeSerdesResult.Single(String.format(MUSIC_WITH_PITCH_VOLUME, content.sound().name(), Float.valueOf(content.pitch()), Float.valueOf(content.volume())));
        }
        return new NoticeSerdesResult.Single(String.format(MUSIC_FULL, content.sound().name(), content.category().name(), Float.valueOf(content.pitch()), Float.valueOf(content.volume())));
    }

    @Override
    public Optional<SoundBukkit> deserialize(NoticeSerdesResult result) {
        Optional<String> firstElement = result.firstElement();
        if (firstElement.isEmpty()) {
            return Optional.empty();
        }
        String[] music = firstElement.get().split(" ");
        if (music.length == 1) {
            return Optional.of(new SoundBukkit(Sound.valueOf((String)music[0]), null, SoundBukkit.PITCH_UNSET.floatValue(), SoundBukkit.VOLUME_UNSET.floatValue()));
        }
        if (music.length != 4 && music.length != 3) {
            throw new IllegalArgumentException("Invalid sound format: " + firstElement.get());
        }
        Sound sound = Sound.valueOf((String)music[0]);
        SoundCategory category = music.length == 3 ? null : SoundCategory.valueOf((String)music[1]);
        float pitch = Float.parseFloat(music[music.length - 2]);
        float volume = Float.parseFloat(music[music.length - 1]);
        return Optional.of(new SoundBukkit(sound, category, pitch, volume));
    }
}

