/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.plugin.lib.com.eternalcode.gitcheck;

import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.gitcheck.GitCheckResult;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.gitcheck.git.GitRelease;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.gitcheck.git.GitReleaseProvider;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.gitcheck.git.GitRepository;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.gitcheck.git.GitTag;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.gitcheck.github.GitHubReleaseProvider;
import com.github.imdmk.spenttime.plugin.lib.com.eternalcode.gitcheck.shared.Preconditions;
import org.jetbrains.annotations.NotNull;

public class GitCheck {
    private final GitReleaseProvider versionProvider;

    public GitCheck() {
        this(new GitHubReleaseProvider());
    }

    public GitCheck(@NotNull GitReleaseProvider versionProvider) {
        Preconditions.notNull(versionProvider, "release provider");
        this.versionProvider = versionProvider;
    }

    @NotNull
    public GitRelease getLatestRelease(@NotNull GitRepository repository) {
        Preconditions.notNull(repository, "repository");
        return this.versionProvider.getLatestRelease(repository);
    }

    @NotNull
    public GitCheckResult checkRelease(@NotNull GitRepository repository, @NotNull GitTag currentTag) {
        Preconditions.notNull(repository, "repository");
        Preconditions.notNull(currentTag, "current tag");
        GitRelease latestRelease = this.getLatestRelease(repository);
        return new GitCheckResult(latestRelease, currentTag);
    }
}

