/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.placeholder;

import com.github.imdmk.spenttime.user.BukkitSpentTime;
import com.github.imdmk.spenttime.util.DurationUtil;
import java.util.Objects;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpentTimePlaceholder
extends PlaceholderExpansion {
    private final PluginDescriptionFile pluginDescriptionFile;
    private final BukkitSpentTime bukkitSpentTime;

    public SpentTimePlaceholder(@NotNull PluginDescriptionFile pluginDescriptionFile, @NotNull BukkitSpentTime bukkitSpentTime) {
        this.pluginDescriptionFile = Objects.requireNonNull(pluginDescriptionFile, "pluginDescriptionFile cannot be null");
        this.bukkitSpentTime = Objects.requireNonNull(bukkitSpentTime, "bukkitSpentTime cannot be null");
    }

    @NotNull
    public String getIdentifier() {
        return "spent-time";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.pluginDescriptionFile.getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.pluginDescriptionFile.getVersion();
    }

    @Nullable
    public String onRequest(@NotNull OfflinePlayer player, @NotNull String params) {
        return DurationUtil.format(this.bukkitSpentTime.getSpentTime(player));
    }
}

