/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.placeholder;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.jetbrains.annotations.NotNull;

public final class PlaceholderRegistry {
    private final Set<PlaceholderExpansion> registeredExpansions = new HashSet<PlaceholderExpansion>();

    public void register(@NotNull PlaceholderExpansion placeholder) {
        Objects.requireNonNull(placeholder, "placeholder cannot be null");
        if (placeholder.register()) {
            this.registeredExpansions.add(placeholder);
        }
    }

    public void unregister(@NotNull PlaceholderExpansion placeholder) {
        Objects.requireNonNull(placeholder, "placeholder cannot be null");
        if (placeholder.unregister()) {
            this.registeredExpansions.remove(placeholder);
        }
    }

    public void unregisterAll() {
        this.registeredExpansions.forEach(this::unregister);
    }

    @NotNull
    public Set<PlaceholderExpansion> getRegisteredExpansions() {
        return Set.copyOf(this.registeredExpansions);
    }
}

