/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.gui.implementation;

import com.github.imdmk.spenttime.feature.gui.AbstractGui;
import com.github.imdmk.spenttime.feature.gui.ParameterizedGui;
import com.github.imdmk.spenttime.feature.gui.configuration.GuiConfiguration;
import com.github.imdmk.spenttime.feature.gui.configuration.item.ItemGui;
import com.github.imdmk.spenttime.feature.gui.configuration.item.ItemGuiConfiguration;
import com.github.imdmk.spenttime.feature.gui.implementation.ConfirmationGuiAction;
import com.github.imdmk.spenttime.plugin.lib.dev.triumphteam.gui.builder.gui.SimpleBuilder;
import com.github.imdmk.spenttime.plugin.lib.dev.triumphteam.gui.guis.BaseGui;
import com.github.imdmk.spenttime.plugin.lib.dev.triumphteam.gui.guis.Gui;
import com.github.imdmk.spenttime.plugin.lib.dev.triumphteam.gui.guis.GuiItem;
import com.github.imdmk.spenttime.task.TaskScheduler;
import java.util.Objects;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ConfirmationGui
extends AbstractGui
implements ParameterizedGui<ConfirmationGuiAction> {
    public static final String GUI_IDENTIFIER = "confirmation";
    private final GuiConfiguration guiConfiguration;
    private final ItemGuiConfiguration itemConfiguration;

    public ConfirmationGui(@NotNull GuiConfiguration guiConfiguration, @NotNull ItemGuiConfiguration itemConfiguration, @NotNull TaskScheduler taskScheduler) {
        super(itemConfiguration, taskScheduler);
        this.guiConfiguration = Objects.requireNonNull(guiConfiguration, "guiConfiguration cannot be null");
        this.itemConfiguration = Objects.requireNonNull(itemConfiguration, "guiItemConfiguration cannot be null");
    }

    @Override
    @NotNull
    public BaseGui createGui(@NotNull Player viewer, @NotNull ConfirmationGuiAction action) {
        return ((SimpleBuilder)((SimpleBuilder)((SimpleBuilder)Gui.gui().title(this.getConfig().title)).rows(6)).disableAllInteractions()).create();
    }

    @Override
    public void prepareBorderItems(@NotNull BaseGui gui) {
        if (this.itemConfiguration.fillBorder) {
            gui.getFiller().fillBorder(this.itemConfiguration.borderItem.asGuiItem());
        }
    }

    @Override
    public void prepareNavigationItems(@NotNull BaseGui gui, @NotNull Player viewer, @NotNull ConfirmationGuiAction action) {
        this.createExitItem(this.itemConfiguration.exitItem.slot(), exit -> gui.close((HumanEntity)viewer)).forEach(gui::setItem);
    }

    @Override
    public void prepareItems(@NotNull BaseGui gui, @NotNull Player viewer, @NotNull ConfirmationGuiAction action) {
        ItemGui confirmItem = this.getConfig().confirmItem;
        ItemGui cancelItem = this.getConfig().cancelItem;
        GuiItem confirmGuiItem = confirmItem.asGuiItem(confirm -> action.onConfirmAccept(viewer));
        GuiItem cancelGuiItem = cancelItem.asGuiItem(cancel -> action.onCancelAccept(viewer));
        gui.setItem(confirmItem.slot(), confirmGuiItem);
        gui.setItem(cancelItem.slot(), cancelGuiItem);
    }

    @Override
    public void defaultClickAction(@NotNull BaseGui gui, @NotNull Player viewer) {
        this.playSoundIfEnabled(gui, viewer, this.guiConfiguration.sound);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return GUI_IDENTIFIER;
    }

    @NotNull
    private GuiConfiguration.ConfirmationGuiConfiguration getConfig() {
        return this.guiConfiguration.confirmationGui;
    }
}

