/*
 * Decompiled with CFR 0.152.
 */
package com.github.imdmk.spenttime.feature.gui.configuration.item;

import com.github.imdmk.spenttime.feature.gui.configuration.item.ItemGui;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.serdes.DeserializationData;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import com.github.imdmk.spenttime.plugin.lib.eu.okaeri.configs.serdes.SerializationData;
import com.github.imdmk.spenttime.plugin.lib.net.kyori.adventure.text.Component;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;

public class ItemGuiSerializer
implements ObjectSerializer<ItemGui> {
    @Override
    public boolean supports(@NotNull Class<? super ItemGui> type) {
        return ItemGui.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NotNull ItemGui item, @NotNull SerializationData data, @NotNull GenericsDeclaration generics) {
        data.add("material", (Object)item.material(), Material.class);
        data.add("name", (Object)item.name(), Component.class);
        data.addCollection("lore", item.lore(), Component.class);
        if (item.slot() > 0) {
            data.add("slot", (Object)item.slot(), Integer.class);
        }
        if (!item.enchantments().isEmpty()) {
            data.addAsMap("enchantments", item.enchantments(), Enchantment.class, Integer.class);
        }
    }

    @Override
    public ItemGui deserialize(@NotNull DeserializationData data, @NotNull GenericsDeclaration generics) {
        Material material = data.get("material", Material.class);
        Component name = data.get("name", Component.class);
        List<Component> lore = data.getAsList("lore", Component.class);
        int slot = data.containsKey("slot") ? data.get("slot", Integer.class) : 0;
        HashMap<Enchantment, Integer> enchantments = data.containsKey("enchantments") ? data.getAsMap("enchantments", Enchantment.class, Integer.class) : new HashMap<Enchantment, Integer>();
        return ItemGui.builder().material(material).nameComponent(name).loreComponent(lore).slot(slot).enchantment(enchantments).build();
    }
}

